local S = minetest.get_translator(minetest.get_current_modname())

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Villager Costume
mcl_armor.register_set({
	name = "halloween_villager",
	descriptions = {
		head = S("Halloween Villager Mask"),
		torso = S("Halloween Villager Costume"),
		legs = S("Halloween Villager Pants"),
		feet = S("Halloween Villager Boots"),
	},	durability = 50,
	points = {
		head = 0,
		torso = 0,
		legs = 0,
		feet = 0,
	},
	groups = { mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_mobitems:leather",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

-- Evoker Costume
mcl_armor.register_set({
	name = "halloween_evoker",
	descriptions = {
		head = S("Halloween Evoker Mask"),
		torso = S("Halloween Evoker Costume"),
		legs = S("Halloween Evoker Pants"),
		feet = S("Halloween Evoker Boots"),
	},	durability = 50,
	points = {
		head = 0,
		torso = 0,
		legs = 0,
		feet = 0,
	},
	groups = { mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_mobitems:leather",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

-- Masks --
-- Spider
minetest.register_tool("m16b_mystic_stones_vl:h_spider_mask", {
	description = S("Halloween Spider Mask"),
	_doc_items_longdesc = mcl_armor.longdesc,
	_doc_items_usagehelp = mcl_armor.usage,
    inventory_image = "m16b_spider_mask_inv.png",
	groups = {armor = 1, non_combat_armor = 1, armor_head = 1, non_combat_torso = 1, mcl_armor_uses = 50, mystic_stones = 1},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "head",
	_mcl_armor_texture = "m16b_spider_mask.png",
	repair_material = "mcl_mobitems:leather",
	_on_equip = function(obj, itemstack)
	end,
	_on_unequip = function(obj, itemstack)
	end,
	_on_break = function(obj)
	end,
})

-- Enderman
minetest.register_tool("m16b_mystic_stones_vl:h_enderman_mask", {
	description = S("Halloween Enderman Mask"),
	_doc_items_longdesc = mcl_armor.longdesc,
	_doc_items_usagehelp = mcl_armor.usage,
    inventory_image = "m16b_enderman_mask_inv.png",
	groups = {armor = 1, non_combat_armor = 1, armor_head = 1, non_combat_torso = 1, mcl_armor_uses = 50, mystic_stones = 1},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "head",
	_mcl_armor_texture = "m16b_enderman_mask.png",
	repair_material = "mcl_mobitems:leather",
	_on_equip = function(obj, itemstack)
	end,
	_on_unequip = function(obj, itemstack)
	end,
	_on_break = function(obj)
	end,
})

-- Piglin
minetest.register_tool("m16b_mystic_stones_vl:h_piglin_mask", {
	description = S("Halloween Piglin Brute Mask"),
	_doc_items_longdesc = mcl_armor.longdesc,
	_doc_items_usagehelp = mcl_armor.usage,
    inventory_image = "m16b_piglin_mask_inv.png",
	groups = {armor = 1, non_combat_armor = 1, armor_head = 1, non_combat_torso = 1, mcl_armor_uses = 50, mystic_stones = 1},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "head",
	_mcl_armor_texture = "m16b_piglin_mask.png",
	repair_material = "mcl_mobitems:leather",
	_on_equip = function(obj, itemstack)
	end,
	_on_unequip = function(obj, itemstack)
	end,
	_on_break = function(obj)
	end,
})

-- Cow
minetest.register_tool("m16b_mystic_stones_vl:h_cow_mask", {
	description = S("Halloween Cow Mask"),
	_doc_items_longdesc = mcl_armor.longdesc,
	_doc_items_usagehelp = mcl_armor.usage,
    inventory_image = "m16b_cow_mask_inv.png",
	groups = {armor = 1, non_combat_armor = 1, armor_head = 1, non_combat_torso = 1, mcl_armor_uses = 50, mystic_stones = 1},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "head",
	_mcl_armor_texture = "m16b_cow_mask.png",
	repair_material = "mcl_mobitems:leather",
	_on_equip = function(obj, itemstack)
	end,
	_on_unequip = function(obj, itemstack)
	end,
	_on_break = function(obj)
	end,
})

if it_is_halloween then
-- Villager Costume
minetest.register_craft({
	output = "m16b_mystic_stones_vl:helmet_halloween_villager",
	recipe = {
		{"mcl_dyes:green", "mcl_mobitems:leather", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:chestplate_halloween_villager",
	recipe = {
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"mcl_dyes:green", "mcl_mobitems:leather", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:leggings_halloween_villager",
	recipe = {
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
		{"mcl_dyes:green", "", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:boots_halloween_villager",
	recipe = {
		{"", "", ""},
		{"mcl_dyes:green", "", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

-- Evoker Costume
minetest.register_craft({
	output = "m16b_mystic_stones_vl:helmet_halloween_evoker",
	recipe = {
		{"mcl_dyes:grey", "mcl_mobitems:leather", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:chestplate_halloween_evoker",
	recipe = {
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"mcl_dyes:grey", "mcl_mobitems:leather", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:leggings_halloween_evoker",
	recipe = {
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
		{"mcl_dyes:grey", "", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:boots_halloween_evoker",
	recipe = {
		{"", "", ""},
		{"mcl_dyes:grey", "", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

-- Masks
minetest.register_craft({
	output = "m16b_mystic_stones_vl:h_spider_mask",
	recipe = {
		{"mcl_dyes:black", "mcl_mobitems:leather", "mcl_dyes:black"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:h_enderman_mask",
	recipe = {
		{"mcl_dyes:purple", "mcl_mobitems:leather", "mcl_dyes:purple"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:h_piglin_mask",
	recipe = {
		{"mcl_dyes:red", "mcl_mobitems:leather", "mcl_dyes:red"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:h_cow_mask",
	recipe = {
		{"mcl_dyes:brown", "mcl_mobitems:leather", "mcl_dyes:brown"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})
end
