local S = minetest.get_translator(minetest.get_current_modname())
local wield_scale = mcl_vars.tool_wield_scale

-- Swords
minetest.register_tool("m16b_mystic_stones_vl:sword_flint", {
	description = S("Flint Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_flint_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=2,
		damage_groups = {fleshy=5},
		punch_attack_uses = 90,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:flint",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 3, level = 2, uses = 90 },
		swordy_cobweb = { speed = 3, level = 2, uses = 90 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:sword_amethyst", {
	description = S("Amethyst Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_amethyst_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=18, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=3,
		damage_groups = {fleshy=6},
		punch_attack_uses = 240,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_amethyst:amethyst_shard",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 4, level = 3, uses = 240 },
		swordy_cobweb = { speed = 4, level = 3, uses = 240 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:sword_ancient", {
	description = S("Ancient Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_ancient_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=7, enchantability=8, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=4,
		damage_groups = {fleshy=10},
		punch_attack_uses = 2040,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "m16b_mystic_stones_vl:ancient_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 10, level = 6, uses = 2040 },
		swordy_cobweb = { speed = 10, level = 6, uses = 2040 }
	},
})


-- Picks
minetest.register_tool("m16b_mystic_stones_vl:pick_flint", {
	description = S("Flint Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_flint_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 90,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:flint",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 3, level = 2, uses = 60 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_amethyst", {
	description = S("Amethyst Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_amethyst_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=18, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=4},
		punch_attack_uses = 240,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_amethyst:amethyst_shard",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 240 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_ancient", {
	description = S("Ancient Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_ancient_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=7, enchantability=8, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=4,
		damage_groups = {fleshy=5},
		punch_attack_uses = 2040,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "m16b_mystic_stones_vl:ancient_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 10, level = 6, uses = 2040 }
	},
})


-- Shovels
minetest.register_tool("m16b_mystic_stones_vl:shovel_flint", {
	description = S("Flint Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = "m16b_flint_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 90,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:flint",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 2, level = 1, uses = 60 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_amethyst", {
	description = S("Amethyst Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = "m16b_amethyst_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=18, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=3,
		damage_groups = {fleshy=3},
		punch_attack_uses = 240,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_amethyst:amethyst_shard",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 4, level = 3, uses = 240 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_ancient", {
	description = S("Ancient Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = "m16b_ancient_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=7, enchantability=8, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=4,
		damage_groups = {fleshy=4},
		punch_attack_uses = 2040,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "m16b_mystic_stones_vl:ancient_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 10, level = 6, uses = 2040 }
	},
})


-- Axes
minetest.register_tool("m16b_mystic_stones_vl:axe_flint", {
	description = S("Flint Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_flint_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=2,
		damage_groups = {fleshy=6},
		punch_attack_uses = 90,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:flint",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 2, level = 1, uses = 60 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_amethyst", {
	description = S("Amethyst Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_amethyst_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=18, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=3,
		damage_groups = {fleshy=9},
		punch_attack_uses = 240,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_amethyst:amethyst_shard",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 4, level = 3, uses = 240 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_ancient", {
	description = S("Ancient Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = "m16b_ancient_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=7, enchantability=8, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=4,
		damage_groups = {fleshy=8},
		punch_attack_uses = 2040,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "m16b_mystic_stones_vl:ancient_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 10, level = 6, uses = 2040 }
	},
})
