local S = minetest.get_translator(minetest.get_current_modname())

-- Strange Stone
minetest.register_craftitem("m16b_mystic_stones_vl:stone", {
	description = S("Strange Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone_base.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:stone 6",
	recipe = {
		{"mcl_core:stone", "mcl_core:stone"},
		{"mcl_core:stone", "mcl_core:stone"},
		{"mcl_core:stone", "mcl_core:stone"},

	},
})

-- Mystical Stones Tier 1 --
-- Mystic Stone Tier 1
minetest.register_craftitem("m16b_mystic_stones_vl:mystic_stone", {
	description = S("Mystic Stone Tier 1"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mystic_stone",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:stone", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Fire Stone
minetest.register_craftitem("m16b_mystic_stones_vl:fire_stone", {
	description = S("Fire Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_fire_stone.png",
	groups = { craftitem = 1, coal=1 },
	_mcl_burntime = 500,
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:fire_stone",
	recipe = {
		{"mcl_fire:flint_and_steel", "mcl_mobitems:flaming_rod", "mcl_core:flint"},
		{"mcl_buckets:bucket_lava", "m16b_mystic_stones_vl:mystic_stone", "mcl_fire:fire_charge"},
		{"mcl_core:flint", "mcl_mobitems:flaming_powder", "mcl_fire:flint_and_steel"},

	},
})

-- Water Stone
minetest.register_craftitem("m16b_mystic_stones_vl:water_stone", {
	description = S("Water Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_water_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:water_stone",
	recipe = {
		{"mcl_flowers:waterlily", "mcl_potions:water", "mcl_ocean:kelp"},
		{"mcl_buckets:bucket_water", "m16b_mystic_stones_vl:mystic_stone", "mcl_buckets:bucket_water"},
		{"mcl_ocean:kelp", "mcl_potions:water", "mcl_flowers:waterlily"},

	},
})

-- Earth Stone
minetest.register_craftitem("m16b_mystic_stones_vl:earth_stone", {
	description = S("Earth Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_earth_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:earth_stone",
	recipe = {
		{"mcl_core:mossycobble", "mcl_core:cobble", "mcl_core:stonebrickmossy"},
		{"mcl_core:stone", "m16b_mystic_stones_vl:mystic_stone", "mcl_core:stone"},
		{"mcl_core:stonebrickmossy", "mcl_core:cobble", "mcl_core:mossycobble"},

	},
})

-- Air Stone
minetest.register_craftitem("m16b_mystic_stones_vl:air_stone", {
	description = S("Air Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_air_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:air_stone",
	recipe = {
		{"mcl_mobitems:feather", "mcl_core:glass", "mcl_mobitems:feather"},
		{"mcl_core:glass", "m16b_mystic_stones_vl:mystic_stone", "mcl_core:glass"},
		{"mcl_mobitems:feather", "mcl_core:glass", "mcl_mobitems:feather"},

	},
})


-- Mystical Stones Tier 2 --
-- Mystic Stone Tier 2
minetest.register_craftitem("m16b_mystic_stones_vl:mystic_stone2", {
	description = S("Mystic Stone Tier 2"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone2.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mystic_stone2",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:mystic_stone", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Flame Stone
minetest.register_craftitem("m16b_mystic_stones_vl:flame_stone", {
	description = S("Flame Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_flame_stone.png",
	groups = { craftitem = 1, coal=1 },
	_mcl_burntime = 1000,
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:flame_stone",
	recipe = {
		{"mcl_mobitems:magma_cream", "m16b_mystic_stones_vl:fire_stone", "mcl_mobitems:magma_cream"},
		{"m16b_mystic_stones_vl:fire_stone", "m16b_mystic_stones_vl:mystic_stone2", "m16b_mystic_stones_vl:fire_stone"},
		{"mcl_mobitems:magma_cream", "m16b_mystic_stones_vl:fire_stone", "mcl_mobitems:magma_cream"},

	},
})

-- River Stone
minetest.register_craftitem("m16b_mystic_stones_vl:river_stone", {
	description = S("River Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_river_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:river_stone",
	recipe = {
		{"mcl_ocean:prismarine", "m16b_mystic_stones_vl:water_stone", "mcl_ocean:prismarine"},
		{"m16b_mystic_stones_vl:water_stone", "m16b_mystic_stones_vl:mystic_stone2", "m16b_mystic_stones_vl:water_stone"},
		{"mcl_ocean:prismarine", "m16b_mystic_stones_vl:water_stone", "mcl_ocean:prismarine"},

	},
})

-- Cave Stone
minetest.register_craftitem("m16b_mystic_stones_vl:cave_stone", {
	description = S("Cave Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_cave_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:cave_stone",
	recipe = {
		{"mcl_deepslate:deepslate_cobbled", "m16b_mystic_stones_vl:earth_stone", "mcl_deepslate:deepslate_cobbled"},
		{"m16b_mystic_stones_vl:earth_stone", "m16b_mystic_stones_vl:mystic_stone2", "m16b_mystic_stones_vl:earth_stone"},
		{"mcl_deepslate:deepslate_cobbled", "m16b_mystic_stones_vl:earth_stone", "mcl_deepslate:deepslate_cobbled"},

	},
})

-- Wind Stone
minetest.register_craftitem("m16b_mystic_stones_vl:wind_stone", {
	description = S("Wind Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_wind_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:wind_stone",
	recipe = {
		{"mcl_core:greysand", "m16b_mystic_stones_vl:air_stone", "mcl_core:greysand"},
		{"m16b_mystic_stones_vl:air_stone", "m16b_mystic_stones_vl:mystic_stone2", "m16b_mystic_stones_vl:air_stone"},
		{"mcl_core:greysand", "m16b_mystic_stones_vl:air_stone", "mcl_core:greysand"},

	},
})

-- Wither Stone
minetest.register_craftitem("m16b_mystic_stones_vl:wither_stone", {
	description = S("Wither Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_wither_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:wither_stone",
	recipe = {
		{"mcl_nether:soul_sand", "mcl_blackstone:soul_soil", "mcl_nether:soul_sand"},
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones_vl:mystic_stone2", "mcl_blackstone:soul_soil"},
		{"mcl_nether:soul_sand", "m16b_mystic_stones_vl:earth_stone", "mcl_nether:soul_sand"},

	},
})

-- Void Stone
minetest.register_craftitem("m16b_mystic_stones_vl:void_stone", {
	description = S("Void Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_void_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:void_stone",
	recipe = {
		{"mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl"},
		{"mcl_throwing:ender_pearl", "m16b_mystic_stones_vl:mystic_stone2", "mcl_throwing:ender_pearl"},
		{"mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl"},

	},
})

-- Mystical Stones Tier 3 --
-- Mystic Stone Tier 3
minetest.register_craftitem("m16b_mystic_stones_vl:mystic_stone3", {
	description = S("Mystic Stone Tier 3"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone3.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mystic_stone3",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:mystic_stone2", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Death Stone
minetest.register_craftitem("m16b_mystic_stones_vl:death_stone", {
	description = S("Death Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_death_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:death_stone",
	recipe = {
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones_vl:wither_stone", "mcl_blackstone:soul_soil"},
		{"m16b_mystic_stones_vl:wither_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:wither_stone"},
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones_vl:wither_stone", "mcl_blackstone:soul_soil"},

	},
})

-- Infernal Stone
minetest.register_craftitem("m16b_mystic_stones_vl:infernal_stone", {
	description = S("Infernal Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_infernal_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:infernal_stone",
	recipe = {
		{"mcl_mobitems:flaming_powder", "m16b_mystic_stones_vl:flame_stone", "mcl_mobitems:flaming_powder"},
		{"m16b_mystic_stones_vl:flame_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:flame_stone"},
		{"mcl_mobitems:flaming_powder", "m16b_mystic_stones_vl:flame_stone", "mcl_mobitems:flaming_powder"},

	},
})

-- End Stone
minetest.register_craftitem("m16b_mystic_stones_vl:end_stone", {
	description = S("End Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_end_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:end_stone",
	recipe = {
		{"mcl_mobitems:shulker_shell", "m16b_mystic_stones_vl:void_stone", "mcl_mobitems:shulker_shell"},
		{"m16b_mystic_stones_vl:void_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:void_stone"},
		{"mcl_mobitems:shulker_shell", "m16b_mystic_stones_vl:void_stone", "mcl_mobitems:shulker_shell"},

	},
})

-- Ocean Stone
minetest.register_craftitem("m16b_mystic_stones_vl:ocean_stone", {
	description = S("Ocean Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_ocean_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:ocean_stone",
	recipe = {
		{"mcl_core:ice", "m16b_mystic_stones_vl:river_stone", "mcl_core:ice"},
		{"m16b_mystic_stones_vl:river_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:river_stone"},
		{"mcl_core:ice", "m16b_mystic_stones_vl:river_stone", "mcl_core:ice"},

	},
})

-- Mineral Stone
minetest.register_craftitem("m16b_mystic_stones_vl:mineral_stone", {
	description = S("Mineral Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mineral_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mineral_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones_vl:cave_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones_vl:cave_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:cave_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:cave_stone", "mcl_core:diamond"},

	},
})

-- Dungeon Stone
minetest.register_craftitem("m16b_mystic_stones_vl:dungeon_stone", {
	description = S("Dungeon Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_dungeon_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:dungeon_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones_vl:water_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones_vl:air_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:earth_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:fire_stone", "mcl_core:diamond"},

	},
})

-- Mystical Stones Tier 4 --
-- Mystic Stone Tier 4
minetest.register_craftitem("m16b_mystic_stones_vl:mystic_stone4", {
	description = S("Mystic Stone Tier 4"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone4.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mystic_stone4",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:mystic_stone3", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Master Stone
minetest.register_craftitem("m16b_mystic_stones_vl:master_stone", {
	description = S("Master Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_master_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:master_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones_vl:water_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones_vl:air_stone", "m16b_mystic_stones_vl:dungeon_stone", "m16b_mystic_stones_vl:earth_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:fire_stone", "mcl_core:diamond"},

	},
})

-- Tsunami Stone
minetest.register_craftitem("m16b_mystic_stones_vl:tsunami_stone", {
	description = S("Tsunami Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_tsunami_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:tsunami_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones_vl:ocean_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones_vl:air_stone", "m16b_mystic_stones_vl:mystic_stone4", "m16b_mystic_stones_vl:air_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:ocean_stone", "mcl_core:diamond"},

	},
})

-- Ender Stone
minetest.register_craftitem("m16b_mystic_stones_vl:ender_stone", {
	description = S("Ender Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_ender_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:ender_stone",
	recipe = {
		{"mcl_end:chorus_flower", "m16b_mystic_stones_vl:end_stone", "mcl_end:chorus_flower"},
		{"m16b_mystic_stones_vl:end_stone", "m16b_mystic_stones_vl:mystic_stone4", "m16b_mystic_stones_vl:end_stone"},
		{"mcl_end:chorus_flower", "m16b_mystic_stones_vl:end_stone", "mcl_end:chorus_flower"},

	},
})

-- Mystical Stones Tier 5 --
-- Mystic Stone Tier 5
minetest.register_craftitem("m16b_mystic_stones_vl:mystic_stone5", {
	description = S("Mystic Stone Tier 5"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone5.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mystic_stone5",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones_vl:mystic_stone4", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Dragon Stone
minetest.register_craftitem("m16b_mystic_stones_vl:dragon_stone", {
	description = S("Dragon Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_dragon_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:dragon_stone",
	recipe = {
		{"mcl_end:crystal", "m16b_mystic_stones_vl:death_stone", "mcl_end:crystal"},
		{"m16b_mystic_stones_vl:death_stone", "m16b_mystic_stones_vl:ender_stone", "m16b_mystic_stones_vl:death_stone"},
		{"mcl_end:crystal", "m16b_mystic_stones_vl:death_stone", "mcl_end:crystal"},

	},
})

-- Forbidden Stone
minetest.register_craftitem("m16b_mystic_stones_vl:forbidden_stone", {
	description = S("Forbidden Mystical Stone"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_forbidden_stone.png",
	groups = { craftitem = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:forbidden_stone",
	recipe = {
		{"m16b_mystic_stones_vl:mineral_stone", "m16b_mystic_stones_vl:infernal_stone", "m16b_mystic_stones_vl:mystic_stone5"},
		{"m16b_mystic_stones_vl:tsunami_stone", "mcl_compressed_blocks:double_compressed_cobblestone", "m16b_mystic_stones_vl:dragon_stone"},
		{"m16b_mystic_stones_vl:wind_stone", "m16b_mystic_stones_vl:death_stone", "m16b_mystic_stones_vl:master_stone"},

	},
})

local modpath = minetest.get_modpath("m16b_mystic_stones_vl")

dofile(modpath .. "/craftings/init.lua")
