local S = core.get_translator(core.get_current_modname())
local horse_armor_use = S("Place it on a horse to put on the horse armor. Donkeys and mules can't wear horse armor.")

core.register_craftitem("m16b_new_mobs:netherite_horse_armor", {
	description = S("Netherite Horse Armor"),
	_doc_items_longdesc = S("Netherite horse armor can be worn by horses to greatly increase their protection from harm."),
	_doc_items_usagehelp = horse_armor_use,
	inventory_image = "m16b_netherite_horse_armor.png",
	_horse_overlay_image = "m16b_horse_armor_netherite.png",
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_diamond",
	},
	stack_max = 1,
	groups = { horse_armor = 40 },
})

core.register_craftitem("m16b_new_mobs:copper_horse_armor", {
	description = S("Copper Horse Armor"),
	_doc_items_longdesc = S("Copper horse armor can be worn by horses to increase their protection from harm a bit."),
	_doc_items_usagehelp = horse_armor_use,
	inventory_image = "m16b_copper_horse_armor.png",
	_horse_overlay_image = "m16b_copper_horse_armor_copper.png",
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_iron",
	},
	stack_max = 1,
	groups = { horse_armor = 87 },
	_mcl_cooking_output = "m16b_new_mobs:copper_nugget"
})

core.register_alias("mobs_mc:netherite_horse_armor", "m16b_new_mobs:netherite_horse_armor")
core.register_alias("mobs_mc:copper_horse_armor", "m16b_new_mobs:copper_horse_armor")
