local S = core.get_translator(core.get_current_modname());

for i, stage in pairs(copper_stages) do

    -- Chains
    local chain_box = { type = "fixed", fixed = { {-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625}} };
    local oxinode = "m16b_new_mobs:copper_chain"..stage.id;
    local can_oxid = 1;
    local node_id = stage.id;
    
    if i < #copper_stages then
        oxinode = "m16b_new_mobs:copper_chain"..copper_stages[i+1].id or oxinode;
    else
        can_oxid = 0;
    end;
    
    local name = stage.name;
    
    for key, wax in pairs({"", "_preserved"}) do
        local back_node_id = "";
        if (wax == "_preserved") then
            can_oxid = 0;
            core.register_alias(
                "m16b_new_mobs:waxed_chain"..node_id, 
                "m16b_new_mobs:copper_chain"..node_id.."_preserved"
            );
            name = "Waxed "..name.." Chain";
            node_id = node_id.."_preserved";
            back_node_id = node_id;
        end;
        
        core.register_node("m16b_new_mobs:copper_chain"..node_id, {
            description = S(name.." Chain"),
            _doc_items_longdesc = S("Chains are copper metallic decoration blocks."),
            inventory_image = "mcl_copper_chain"..stage.id..".png",
            tiles = {"mcl_copper_chain"..stage.id.."_texture.png"},
            drawtype = "mesh",
            paramtype = "light",
            paramtype2 = "facedir",
            use_texture_alpha = "clip",
            mesh = "mcl_lanterns_chain.obj",
            is_ground_content = false,
            sunlight_propagates = true,
            collision_box = chain_box,
            selection_box = chain_box,
            groups = {pickaxey=1, deco_block = 1, can_oxid=can_oxid, fence=1},
            sounds = mcl_sounds.node_sound_metal_defaults(),
            oxinode = oxinode,
            back_node_id = back_node_id,
            on_place = function(itemstack, placer, pointed_thing)
                if pointed_thing.type ~= "node" or not placer or not placer:is_player() then
                    return itemstack
                end

                local p0 = pointed_thing.under
                local p1 = pointed_thing.above
                local param2 = 0

                local placer_pos = placer:get_pos()
                if placer_pos then
                    local dir = {
                        x = p1.x - placer_pos.x,
                        y = p1.y - placer_pos.y,
                        z = p1.z - placer_pos.z
                    }
                    param2 = core.dir_to_facedir(dir)
                end

                if p0.y - 1 == p1.y then
                    param2 = 20
                elseif p0.x - 1 == p1.x then
                    param2 = 16
                elseif p0.x + 1 == p1.x then
                    param2 = 12
                elseif p0.z - 1 == p1.z then
                    param2 = 8
                elseif p0.z + 1 == p1.z then
                    param2 = 4
                end

                return core.item_place_node(itemstack, placer, pointed_thing, param2)
            end,
            _mcl_blast_resistance = 6,
            _mcl_hardness = 5,
        })
    end
    
    core.register_craft({
        output = "m16b_new_mobs:copper_chain",
        recipe = {
            {"m16b_new_mobs:copper_nugget"},
            {"mcl_copper:copper_ingot"},
            {"m16b_new_mobs:copper_nugget"},
        },
    })
    
end
