local S = core.get_translator(core.get_current_modname())

local function on_bone_meal(itemstack,placer,pointed_thing,pos,node)
	return mcl_farming.on_bone_meal(itemstack,placer,pointed_thing,pos,node,"plant_torchflower")
end

for i=1, 7 do
	local texture, sel_height
	if i < 3 then
		sel_height = -0.5+(2/16)
		texture = "m16b_torchflower_1.png"
	else
		sel_height = -0.5+(6/16)
		texture = "m16b_torchflower_2.png"
	end

	local create, name, longdesc
	if i == 1 then
		create = true
		name = S("Premature Torchflower")
	else
		create = false
	end
	core.register_node("m16b_new_mobs:torchflower_"..i, {
		description = S("Premature Torchflower (Stage @1)", i),
		_doc_items_create_entry = create,
		_doc_items_entry_name = name,
		_doc_items_longdesc = longdesc,
		paramtype = "light",
		sunlight_propagates = true,
		paramtype2 = "meshoptions",
		place_param2 = 3,
		walkable = false,
		drawtype = "plantlike",
		drop = "m16b_new_mobs:torchflower_seed",
		tiles = {texture},
		inventory_image = texture,
		wield_image = texture,
		selection_box = {
			type = "fixed",
			fixed = {
				{-7/16, -0.5 ,-7/16, 7/16, sel_height ,7/16}
			},
		},
		groups = {dig_immediate=3, not_in_creative_inventory=1,plant=1,attached_node=1,dig_by_water=1,destroy_by_lava_flow=1,dig_by_piston=1,carrot=i},
		sounds = mcl_sounds.node_sound_leaves_defaults(),
		_mcl_hardness = 0,
		_on_bone_meal = on_bone_meal,
		_mcl_baseitem = "m16b_new_mobs:torchflower_item",
	})
end

core.register_node("m16b_new_mobs:torchflower", {
	description = S("Mature Torchflower"),
	paramtype = "light",
	sunlight_propagates = true,
	paramtype2 = "meshoptions",
	place_param2 = 3,
	walkable = false,
	drawtype = "plantlike",
	tiles = {"vlf_flowers_torchflower.png"},
	inventory_image = "vlf_flowers_torchflower.png",
	wield_image = "vlf_flowers_torchflower.png",
	drop = {
		max_items = 1,
		items = {
			{ items = {"mcl_flowers:torchflower 1"} },
		}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-7/16, -0.5 ,-7/16, 7/16, -0.5+(8/16) ,7/16}
		},
	},
	groups = {dig_immediate=3, not_in_creative_inventory=1,plant=1,attached_node=1,dig_by_water=1,destroy_by_lava_flow=1,dig_by_piston=1,carrot=8},
	sounds = mcl_sounds.node_sound_leaves_defaults(),
	_mcl_hardness = 0,
	_on_bone_meal = on_bone_meal,
	_mcl_fortune_drop = {
		discrete_uniform_distribution = true,
		items = {"mcl_flowers:torchflower"},
		min_count = 2,
		max_count = 4,
		cap = 5,
	},
	_mcl_baseitem = "mcl_flowers:torchflower",
})

mcl_flowers.register_simple_flower("torchflower", {
	desc = S("Torchflower"),
	image = "vlf_flowers_torchflower.png",
	selection_box = { -5/16, -0.5, -5/16, 5/16, 5/16, 5/16 },
	potted = true,
	_mcl_crafting_output = {single = {output = "mcl_dyes:orange"}}
})

core.register_craftitem("m16b_new_mobs:torchflower_seed", {
	description = S("Torchflower Seeds"),
	_tt_help = S("A flower finded from the Sniffer"),
	groups = {sniffer_flower = 1, compostability = 30},
	inventory_image = "m16b_torchflower_seeds.png",
	wield_image = "m16b_torchflower_seeds.png",
	_mcl_places_plant = "m16b_new_mobs:torchflower_1",
	on_place = function(itemstack, placer, pointed_thing)
		return mcl_farming:place_seed(itemstack, placer, pointed_thing, "m16b_new_mobs:torchflower_1")
	end
})

mcl_farming:add_plant("plant_torchflower", "m16b_new_mobs:torchflower", {"m16b_new_mobs:torchflower_1", "m16b_new_mobs:torchflower_2", "m16b_new_mobs:torchflower_3", "m16b_new_mobs:torchflower_4", "m16b_new_mobs:torchflower_5", "m16b_new_mobs:torchflower_6", "m16b_new_mobs:torchflower_7"}, 25, 20)

if core.get_modpath("doc") then
	for i=2,7 do
		doc.add_entry_alias("nodes", "m16b_new_mobs:torchflower_1", "nodes", "m16b_new_mobs:torchflower_"..i)
	end
end
