local S = core.get_translator(core.get_current_modname());

mcl_torches.register_torch({
	name = "copper_torch",
	description = S("Copper Torch"),
	doc_items_longdesc = S("Copper Torches are light sources which can be placed at the side or on the top of most blocks."),
	doc_items_hidden = false,
	icon = "m16b_copper_torch_floor.png",
	tiles = {{
		name = "m16b_copper_torch_animated.png",
		animation = {type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3}
	}},
	light =  14,
	groups = {dig_immediate = 3, deco_block = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	particles = true,
	flame_type = 1,
})

core.register_craft({
	output = "m16b_new_mobs:copper_torch 4",
	recipe = {
		{"m16b_new_mobs:copper_nugget"},
		{"group:coal"},
		{"mcl_core:stick"},
	}
})

for i, stage in pairs(copper_stages) do

    local oxinode = "mcl_lanterns:copper_lantern"..stage.id.."_floor";
    local can_oxid = 1;
    
    if i < #copper_stages then
        oxinode = "mcl_lanterns:copper_lantern"..copper_stages[i+1].id.."_floor" or oxinode;
    else
        can_oxid = 0;
    end;
    
    local name = stage.name;
    local node_id = "copper_lantern"..stage.id;

    for key, wax in pairs({"", "_preserved"}) do
        back_node_id = "";
        if (wax == "_preserved") then
            can_oxid = 0;
            name = "Waxed "..name;
            node_id = node_id.."_preserved";
            back_node_id = node_id;
        end;
    
        mcl_lanterns.register_lantern(node_id, {
            description = S(name.." Lantern"),
            longdesc = S("Lanterns are light sources which can be placed on the top or the bottom of most blocks."),
            texture = "mcl_copper_lantern"..stage.id..".png",
            texture_inv = "mcl_copper_lantern"..stage.id.."_inv.png",
            light_level = core.LIGHT_MAX-i,
            groups = {can_oxid=can_oxid},
        })
    end
    
end

core.register_craft({
    output = "mcl_lanterns:copper_lantern_floor",
    recipe = {
        {"m16b_new_mobs:copper_nugget", "m16b_new_mobs:copper_nugget", "m16b_new_mobs:copper_nugget"},
        {"m16b_new_mobs:copper_nugget", "m16b_new_mobs:copper_torch",  "m16b_new_mobs:copper_nugget"},
        {"m16b_new_mobs:copper_nugget", "m16b_new_mobs:copper_nugget", "m16b_new_mobs:copper_nugget"},
    },
});
