local S = core.get_translator("m16b_new_mobs")
local mob_class = mcl_mobs.mob_class
local skeleton = mobs_mc.skeleton

------------------------------------------------------------------------
-- Bogged.
------------------------------------------------------------------------

local bogged = table.merge (skeleton, {
	description = S("Bogged"),
	textures = {
		{
			"mobs_mc_empty.png", -- armor
			"m16b_bogged_overlay.png",
			"m16b_bogged.png",
		},
	},
	drops = {
		{
			name = "mcl_bows:arrow",
			chance = 1,
			min = 0,
			max = 2,
			looting = "common",
		},
		{
			name = "mcl_mobitems:bone",
			chance = 1,
			min = 0,
			max = 2,
			looting = "common",
		},
		{
			name = "mcl_potions:poison_arrow",
			chance = 2,
			min = 1,
			max = 1,
			looting = "rare",
		},
	},
})

function bogged:shoot_arrow (pos, dir)
	local wielditem = self:get_wielditem ()
	mcl_bows.shoot_arrow ("mcl_potions:poison_arrow", pos, dir,
			self:get_yaw (), self.object, 0.5333333, nil,
			false, wielditem)
end

mcl_mobs.register_mob ("m16b_new_mobs:bogged", bogged)

------------------------------------------------------------------------
-- Bogged spawning.
------------------------------------------------------------------------

mcl_mobs.spawn_setup ({
	name = "m16b_new_mobs:bogged",
	type_of_spawning = "ground",
	dimension = "overworld",
	aoc = 2,
	biomes = {
		"Swampland",
	},
	chance = 1200,
})

mcl_mobs.register_egg ("m16b_new_mobs:bogged", S("Bogged"), "#556B2F", "#8FBC8F", 0)

------------------------------------------------------------------------
-- Bogged spawning.
------------------------------------------------------------------------

local bogged_spawner = table.merge (mobs_mc.monster_spawner, {
	name = "m16b_new_mobs:bogged",
	weight = 80,
	pack_max = 4,
	pack_min = 4,
	biomes = {
		"Swampland",
	},
})

mcl_mobs.register_spawner (bogged_spawner)
