local S = core.get_translator(core.get_current_modname());

for i, stage in pairs(copper_stages) do

    local oxinode = "mcl_panes:copper_bar"..stage.id;
    local can_oxid = 1;
    
    if i < #copper_stages then
        oxinode = "mcl_panes:copper_bar"..copper_stages[i+1].id or oxinode;
    else
        can_oxid = 0;
    end;
    
    local name = stage.name;
    local node_id = "copper_bar"..stage.id;

    for key, wax in pairs({"", "_preserved"}) do
        back_node_id = "";
        if (wax == "_preserved") then
            can_oxid = 0;
            name = "Waxed "..name;
            node_id = node_id.."_preserved";
            back_node_id = node_id;
        end;
    
        mcl_panes.register_pane(node_id, {
            description = S(name.." Bars"),
        	textures = {"m16b_copper_bars"..stage.id..".png","m16b_copper_bars"..stage.id..".png","m16b_copper_bars_top"..stage.id..".png"},
        	inventory_image = "m16b_copper_bars"..stage.id..".png",
        	wield_image = "m16b_copper_bars"..stage.id..".png",
            groups = {can_oxid=can_oxid},
        	use_texture_alpha = "clip",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
	},
	        _mcl_blast_resistance = 6,
	        _mcl_hardness = 5,
        })
    end
    
end
