local S = core.get_translator("m16b_new_mobs")
local mob_class = mcl_mobs.mob_class
local skeleton = mobs_mc.skeleton

------------------------------------------------------------------------
-- Parched.
------------------------------------------------------------------------

local parched = table.merge (skeleton, {
	description = S("Parched"),
	textures = {
		{
			"mobs_mc_empty.png", -- armor
			"m16b_parched_overlay.png",
			"m16b_parched.png",
		},
	},
	drops = {
		{
			name = "mcl_bows:arrow",
			chance = 1,
			min = 0,
			max = 2,
			looting = "common",
		},
		{
			name = "mcl_mobitems:bone",
			chance = 1,
			min = 0,
			max = 2,
			looting = "common",
		},
		{
			name = "mcl_potions:weakness_arrow",
			chance = 2,
			min = 1,
			max = 1,
			looting = "rare",
		},
	},
	ignited_by_sunlight = false,
	avoids_sunlight = false,
})

function parched:shoot_arrow (pos, dir)
	local wielditem = self:get_wielditem ()
	mcl_bows.shoot_arrow ("mcl_potions:weakness_arrow", pos, dir,
			self:get_yaw (), self.object, 0.5333333, nil,
			false, wielditem)
end

mcl_mobs.register_mob ("m16b_new_mobs:parched", parched)

------------------------------------------------------------------------
-- Parched spawning.
------------------------------------------------------------------------

mcl_mobs.spawn_setup ({
	name = "m16b_new_mobs:parched",
	type_of_spawning = "ground",
	dimension = "overworld",
	aoc = 2,
	biomes = {
		"Desert",
	},
	chance = 1200,
})

mcl_mobs.register_egg ("m16b_new_mobs:parched", S("Parched"), "#BDB76B", "#dae8e7", 0)

------------------------------------------------------------------------
-- Parched spawning.
------------------------------------------------------------------------

local parched_spawner = table.merge (mobs_mc.monster_spawner, {
	name = "m16b_new_mobs:parched",
	weight = 80,
	pack_max = 4,
	pack_min = 4,
	biomes = {
		"Desert",
	},
})

mcl_mobs.register_spawner (parched_spawner)
