local S = minetest.get_translator(minetest.get_current_modname())

-- Resin
core.register_node("m16b_new_mobs:resin", {
	description = S("Resin"),
	drawtype = "signlike",
	tiles = {"resin_clump.png"},
	inventory_image = "resin_clump_inv.png",
	wield_image = "resin_clump_inv.png",
	paramtype = "light",
	sunlight_propagates = true,
	paramtype2 = "wallmounted",
	walkable = false,
	climbable = false,
	buildable_to = true,
	selection_box = {
		type = "wallmounted",
	},
	groups = {
		handy = 1, axey = 1, shearsy = 1, swordy = 1, deco_block = 1,
		dig_by_piston = 1,
	},
	sounds = sounds,
	drop = "m16b_new_mobs:resin",
	_mcl_shears_drop = true,
	node_placement_prediction = "",
	_mcl_hardness = 0.2,
	on_rotate = true,
	_mcl_cooking_output = "m16b_new_mobs:resin_brick",
})

-- Resin Block
minetest.register_node("m16b_new_mobs:resin_block",{
	description = S("Resin Block"),
	tiles = {"resin_block.png"},
	groups = {pickaxey = 1, building_block = 1},
	sounds = sounds,
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 1.5,
})

minetest.register_craft({
	output = "m16b_new_mobs:resin_block",
	recipe = {
		{"m16b_new_mobs:resin", "m16b_new_mobs:resin", "m16b_new_mobs:resin"},
		{"m16b_new_mobs:resin", "m16b_new_mobs:resin", "m16b_new_mobs:resin"},
		{"m16b_new_mobs:resin", "m16b_new_mobs:resin", "m16b_new_mobs:resin"},

	},
})

-- Resin Brick
core.register_craftitem("m16b_new_mobs:resin_brick", {
	description = S("Resin Brick"),
	_doc_items_longdesc = S("You can use resin brick for create blocks."),
	_doc_items_hidden = false,
	inventory_image = "m16b_resin_brick.png",
	groups = { craftitem=1 },
	_mcl_armor_trim_color = "#f0852a",
	_mcl_armor_trim_desc = S("Resin Material"),
	_mcl_crafting_output = {square2 = {output = "m16b_new_mobs:resin_brick_block"}}
})

-- Resin Bricks Block
minetest.register_node("m16b_new_mobs:resin_brick_block",{
	description = S("Resin Bricks"),
	_doc_items_longdesc = S(""),
	tiles = {"resin_bricks.png"},
	groups = {pickaxey = 1, building_block = 1, stonecuttable = 1},
	sounds = sounds,
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 1.5,
})

mcl_stairs.register_stair_and_slab("resin_brick", {
	baseitem = "m16b_new_mobs:resin_brick_block",
	description_stair = S("Resin Brick Stairs"),
	description_slab = S("Resin Brick Slab"),
	overrides = {_mcl_stonecutter_recipes = { "m16b_new_mobs:resin_brick_block" }}
})

mcl_walls.register_wall_def("m16b_new_mobs:wall", {
	description = S("Resin Brick Wall"),
	source = "m16b_new_mobs:resin_brick_block",
	_mcl_stonecutter_recipes = {"m16b_new_mobs:resin_brick_block"},
})

-- Chiseled Resin Bricks
minetest.register_node("m16b_new_mobs:chiseled_resin",{
	description = S("Chiseled Resin Bricks"),
	tiles = {"chiseled_resin_bricks.png"},
	groups = {pickaxey = 1, building_block = 1, stonecuttable = 1},
	sounds = sounds,
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 1.5,
    _mcl_stonecutter_recipes = { "m16b_new_mobs:resin_brick_block", },
})
