local S = core.get_translator(modname)

core.register_node("m16b_new_mobs:blue_cave_vines", {
	description = S("Blue Cave vines"),
	_doc_items_create_entry = S("Blue Cave vines"),
	_doc_items_entry_name = S("Blue Cave vines"),
	_doc_items_longdesc = S("Blue Cave vines are decorative blocks growing from the ceiling of lush caves."),
	_doc_items_hidden = false,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	drawtype = "plantlike",
	tiles = {"mcl_lush_caves_cave_vines.png"},
	inventory_image = "mcl_lush_caves_cave_vines.png",
	wield_image = "mcl_lush_caves_cave_vines.png",
	selection_box = {
		type = "fixed",
		fixed = {
			{-7/16, -0.5, -7/16, 7/16, 0.5, 7/16}
		},
	},
	groups = {
		handy=1, plant=1, vinelike_node=2,
		dig_by_water=1, destroy_by_lava_flow=1, dig_by_piston=1,
		deco_block=1, not_in_creative_inventory=1
	},
	sounds = mcl_sounds.node_sound_leaves_defaults(),
	_mcl_hardness = 0,
	drop = "",
	_on_bone_meal = function(_, _, _, pos, node)
		core.set_node(pos,{name="m16b_new_mobs:blue_cave_vines_lit",
			param2=node.param2})
		return true
	end,
	_mcl_on_rightclick_optional = function (pos, node, clicker, itemstack)
		local item_name = clicker:get_wielded_item():get_name()
		local shears = core.get_item_group(item_name, "shears") > 0
		local tip = mcl_util.traverse_tower(pos, -1)

		if shears and vector.equals(pos, tip) then
			core.sound_play("mcl_tools_shears_cut", {pos = pos}, true)
			local wear = mcl_autogroup.get_wear(item_name, "shearsy")
			itemstack:add_wear(wear)
			node.param2 = 25
			core.swap_node(pos,node)
		end
	end
})

core.register_node("m16b_new_mobs:blue_cave_vines_lit", {
	description = S("Blue Lit Cave vines"),
	_doc_items_create_entry = S("Blue Lit Cave vines"),
	_doc_items_entry_name = S("Blue Lit Cave vines"),
	_doc_items_longdesc = S("Blue Lit cave vines are light emitting decorative blocks growing from the ceiling of lush caves."),
	_doc_items_hidden = false,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	drawtype = "plantlike",
	light_source = 14,
	tiles = {"m16b_blue_cave_vines_lit.png"},
	inventory_image = "m16b_blue_cave_vines_lit.png",
	wield_image = "m16b_blue_cave_vines_lit.png",
	selection_box = {
		type = "fixed",
		fixed = {
			{-7/16, -0.5, -7/16, 7/16, 0.5, 7/16}
		},
	},
	groups = {
		handy=1, plant=1, vinelike_node=2,
		dig_by_water=1, destroy_by_lava_flow=1, dig_by_piston=1,
		deco_block=1, not_in_creative_inventory=1
	},
	sounds = mcl_sounds.node_sound_leaves_defaults(),
	_mcl_hardness = 0,
	_mcl_shears_drop = true,
	drop = "m16b_new_mobs:blue_glow_berry",
	on_rightclick = function(pos, node)
		core.add_item(pos,"m16b_new_mobs:blue_glow_berry")
		core.set_node(pos,{name="m16b_new_mobs:blue_cave_vines",
			param2=node.param2})
	end,
})

core.register_craftitem("m16b_new_mobs:blue_glow_berry", {
	description = S("Blue Glow berry"),
	_tt_help = S("This is an easter egg. 24/24"),
	_doc_items_hidden = false,
	inventory_image = "m16b_blue_glow_berry.png",
	on_secondary_use = core.item_eat(2),
	groups = {food = 2, eatable = 2, compostability = 50},
	_mcl_saturation = 1.2,
	on_place = function(itemstack, placer, pointed_thing)
		local rc = mcl_util.call_on_rightclick(itemstack, placer, pointed_thing)
		if rc then return rc end

		if not pointed_thing.under
			or vector.direction (pointed_thing.under, pointed_thing.above).y ~= -1 then
			return core.do_item_eat(2, nil, itemstack, placer, pointed_thing)
		end

		if mcl_util.check_position_protection(pointed_thing.above, placer) then return end

		local vine = "m16b_new_mobs:blue_cave_vines"

		local node = core.get_node(pointed_thing.under)

		if core.get_item_group(node.name, "vinelike_node") == 2
		and node.name ~= vine then return end

		local age = node.param2 + 1
		if node.name ~= vine then age = 0 end

		core.place_node(pointed_thing.under, {name=vine}, placer)

		-- Grow berry if lucky
		if math.random() <= 0.11 then
			vine = "m16b_new_mobs:blue_cave_vines_lit"
		end

		core.swap_node(vector.offset(pointed_thing.under,0,-1,0),
			{name=vine, param2=age})

		core.sound_play(core.registered_nodes[vine].sounds.place, {pos=pointed_thing.above, gain=1}, true)
		if not core.is_creative_enabled(placer:get_player_name()) then
			itemstack:take_item(1)
		end
		return itemstack
	end
})
