local S = core.get_translator(modname)

local function on_place(itemstack, placer, pointed_thing)
	-- Placement is only allowed on top of solid blocks
	if pointed_thing.type ~= "node" then
		-- no interaction possible with entities
		return itemstack
	end
	local def = core.registered_nodes[core.get_node(pointed_thing.under).name]
	local above = pointed_thing.above
	local under = pointed_thing.under

	local rc = mcl_util.call_on_rightclick(itemstack, placer, pointed_thing)
	if rc then return rc end

	-- Get position where snow would be placed
	local target
	if def and def.buildable_to then
		target = under
	else
		target = above
	end
	local tnode = core.get_node(target)

	-- Stack sand
	local g = core.get_item_group(tnode.name, "top_sand")
	if g == 8 then
		local p = vector.offset(target, 0,1,0)
		if core.get_node(p).name == "air" then
			core.set_node(p, {name="m16b_new_mobs:sand_layer"})
			if not core.is_creative_enabled(placer:get_player_name()) then
				itemstack:take_item()
			end
		end
		return itemstack
	elseif g > 0 then
		local itemstring = itemstack:get_name()
		local itemcount = itemstack:get_count()
		local fakestack = ItemStack(itemstring.." "..itemcount)
		fakestack:set_name("m16b_new_mobs:sand_layer_"..(g+1))
		itemstack = core.item_place_node(fakestack, placer, pointed_thing)
		core.sound_play(mcl_sounds.node_sound_sand_defaults().place, {pos = pointed_thing.under}, true)
		itemstack:set_name(itemstring)
		return itemstack
	end

	-- Place sand normally
	local below = {x=target.x, y=target.y-1, z=target.z}
	local bnode = core.get_node(below)

	if core.get_item_group(bnode.name, "solid") == 1 then
		core.sound_play(mcl_sounds.node_sound_sand_defaults().place, {pos = below}, true)
		return core.item_place_node(itemstack, placer, pointed_thing)
	else
		return itemstack
	end
end

for i=1,8 do
	local id, desc, longdesc, usagehelp, tt_help, help, walkable, drawtype, node_box
	if i == 1 then
		id = "m16b_new_mobs:sand_layer"
		desc = S("Top Sand")
		tt_help = S("This is an easter egg. 20/24")
		walkable = false
	else
		id = "m16b_new_mobs:sand_layer_"..i
		help = false
		if core.get_modpath("doc") then
			doc.add_entry_alias("nodes", "m16b_new_mobs:sand_layer", "nodes", id)
		end
		walkable = true
	end
	if i ~= 8 then
		drawtype = "nodebox"
		node_box = {
			type = "fixed",
			fixed = { -0.5, -0.5, -0.5, 0.5, -0.5 + (2*i)/16, 0.5 },
		}
	end

	core.register_node(id, {
		description = desc,
		_tt_help = tt_help,
		_doc_items_longdesc = longdesc,
		_doc_items_usagehelp = usagehelp,
		_doc_items_create_entry = help,
		_doc_items_hidden = false,
		tiles = {"default_sand.png"},
		wield_image = "default_sand.png",
		wield_scale = { x=1, y=1, z=i },
		paramtype = "light",
		sunlight_propagates = true,
		buildable_to = true,
		node_placement_prediction = "", -- to prevent client flickering when stacking sand
		drawtype = drawtype,
		walkable = walkable,
		floodable = true,
		node_box = node_box,
		groups = {shovely=1, attached_node=1, deco_block=1, dig_by_water=1, dig_by_piston=1, m16b_mods=1, sand_cover=1, top_sand=i, unsticky = 1, pathfinder_partial = i < 4 and 1 or 2, sand_layer=1,},
		sounds = mcl_sounds.node_sound_sand_defaults(),
		on_construct = mcl_core.on_sand_construct,
		on_place = on_place,
		after_destruct = mcl_core.after_sand_destruct,
		drop = "m16b_new_mobs:sand_layer ",
		_mcl_hardness = 0.1,
		_mcl_silk_touch_drop = {"m16b_new_mobs:sand_layer " .. i},
	})
end
