


local function on_use_page(itemstack, user, pointed_thing)
        local player_name = user:get_player_name()
        local esc = minetest.formspec_escape        
        
        
        local meta = itemstack:get_meta():to_table()
        print("itemstack:meta()="..dump(meta))
        
        minetest.create_detached_inventory("slots")
        local inv = minetest.create_detached_inventory("inventory_name", {
            allow_move = function(inv, from_list, from_index, to_list, to_index, count, player)
                return count -- allow moving
            end,

            allow_put = function(inv, listname, index, stack, player)
                return stack:get_count() -- allow putting
            end,

            allow_take = function(inv, listname, index, stack, player)
                return -1 -- don't allow taking
            end,

            on_put = function(inv, listname, index, stack, player)
                minetest.chat_send_all(player:get_player_name() ..
                    " gave " .. stack:to_string() ..
                    " to the donation chest from " .. minetest.pos_to_string(player:get_pos()))
            end,
        })

        local formspec = "size[10,8]" ..
        "list[detached:inventory_name;main;0.5,0;8,4]"..
        "list[current_player;main;0,3;8,4]"..
        ""
        
        local stack = ItemStack("default:dirt 7")
        inv:set_size("main",8)
        inv:add_item("main",stack)
        
        
        minetest.show_formspec(player_name,"mesecons_autowire:page", formspec)

        
end


minetest.register_craftitem("mesecons_autowire:page_empty", {
                description = "Circuit Page empty",
                --inventory_image = "circuit_empty.png",
                inventory_image = "page_empty.png",
                --groups = {book = 1, flammable = 3},
                
                on_use = on_use_page
                
        })

minetest.register_craftitem("mesecons_autowire:page_full", {
                description = "Circuit page saved",
                --inventory_image = "circuit_full.png",
                inventory_image = "page_full.png",
                --groups = {book = 1, not_in_creative_inventory = 1, flammable = 3},
                groups = { not_in_creative_inventory = 1},
                stack_max = 1,
                --on_use = on_use_circuit,
                --on_place = on_place_circuit,
                --on_secondary_use = on_place_circuit
               
                
        })
