------------------------------------------------------------
-- Copyleft (Я) 2024 mazes
-- https://gitlab.com/mazes_80/lock_replica
------------------------------------------------------------
local S = minetest.get_translator("lock_replica")

local replicator_uses = 32
local charge_per_lock = 100
local max_charge      = replicator_uses * charge_per_lock + 1

local is_door_owner

local is_door_owner_mtg = function(_, meta, pn)	-- mtg doors
	return meta:get_string("owner") == pn or
		minetest.check_player_privs(pn, "protection_bypass")
end
local is_door_owner_dr = function(_, meta, pn)	-- doors redo
	if is_door_owner_mtg(nil, meta, pn) or
		meta:get_string("doors_protected") == pn then
		return true
	end
end
local is_door_owner_drm = function(pos, meta, pn)	-- doors redo
	if is_door_owner_dr(nil, meta, pn) then
		return true
	end

	-- doors redo flavor mazes_80
	if 	meta:get_string("doors_protected") ~= "" and
		meta:get_string("doors_mode") ~= "" then
		return not minetest.is_protected(pos, pn)
	end
end

if doors.mod ~= "redo" then -- mtg vanilla doors mod
	is_door_owner = is_door_owner_mtg
elseif doors.flavor ~= "mazes_80" then -- doors redo
	is_door_owner = is_door_owner_dr
else -- doors redo mazes_80 fork
	is_door_owner = is_door_owner_drm
end

local chests = { "default:chest_locked" }

local mod_technic
if minetest.get_modpath("technic") then
	mod_technic = true
end
if minetest.get_modpath("technic_chests") then
	for _, m in ipairs({"iron", "copper", "silver", "gold", "mithril"}) do
		table.insert(chests, "technic:" .. m .. "_locked_chest")
	end
end

local is_valid_chest = function(node_name)
	for _, c in ipairs(chests) do
		if node_name == c then
			return true
		end
	end
end

local replicator_replicate = function(itemstack, secret, pn, meta)
	if secret == meta:get_string("key_lock_secret") then
		return -- Do not copy same secret
	end
	minetest.chat_send_player(pn, S("Lock shape remolded") )
	meta:set_string("key_lock_secret", secret)
	itemstack:add_wear_by_uses(replicator_uses)
	return itemstack
end

-- replicate a lock
local replicator_on_place = function(itemstack, placer, pointed_thing)
	-- is replicator loaded
	local secret = itemstack:get_meta():get_string("key_lock_secret")
	if secret == "" then return end

	local current_charge
	if mod_technic then -- Do not waste item on last charge
		current_charge = technic.get_RE_charge(itemstack)
		if current_charge < charge_per_lock then
			return
		end
	end

	if pointed_thing.type == "node" then -- node pointed
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		local node_meta = minetest.get_meta(pos)
		local pn = placer:get_player_name()
		if minetest.get_item_group(node.name, "door") ~= 0 then -- node is a "door"
			if is_door_owner(pos, node_meta, pn) then -- player is able to "share keys"
				return replicator_replicate(itemstack, secret, pn, node_meta)
			end
		elseif is_valid_chest(node.name) then -- check for locked chest
			if node_meta:get_string("owner") == pn or
				minetest.check_player_privs(pn, "protection_bypass") then
				return replicator_replicate(itemstack, secret, pn, node_meta)
			end
		end
	elseif pointed_thing.type == "object" then -- object pointed
		local luaentity = pointed_thing.ref:get_luaentity()
		local pn = placer:get_player_name()
		if  not luaentity or ( luaentity.owner ~= pn and
			not minetest.check_player_privs(pn, "protection_bypass")) or
			not luaentity.on_skeleton_key_use or -- entity cannot have keys
			luaentity.key_lock_secret == itemstack:get_meta():get_string("key_lock_secret") then
			return
		end
		minetest.chat_send_player(pn, S("Lock shape remolded") )
		itemstack:add_wear_by_uses(replicator_uses)
		luaentity.key_lock_secret = secret
		placer:set_wielded_item(itemstack)
	end
end

local replicator_store_secret = function(itemstack, secret, playername)
	if secret == itemstack:get_meta():get_string("key_lock_secret") then
		return -- Do not copy same secret
	end
	itemstack:get_meta():set_string("key_lock_secret", secret)
	minetest.chat_send_player(playername, S("Lock shape stored"))
	itemstack:add_wear_by_uses(replicator_uses)
	return itemstack
end

-- store lock "shape"
local replicator_on_use = function(itemstack, user, pointed_thing)
	local current_charge
	if mod_technic then -- Do not waste item on last charge
		current_charge = technic.get_RE_charge(itemstack)
		if current_charge < charge_per_lock then
			return
		end
	end

	if pointed_thing.type == "node" then -- node pointed
		local pos = pointed_thing.under
		local node_meta = minetest.get_meta(pos)
		local secret = node_meta:get_string("key_lock_secret")
		if secret ~= "" then -- node got a "lock"
			local node = minetest.get_node(pos)
			local pn = user:get_player_name()
			if minetest.get_item_group(node.name, "door") ~= 0	then -- node is a door
				if is_door_owner(pos, node_meta, pn) then		-- player is able to "share key"
					return replicator_store_secret(itemstack, secret, pn)
				end
			elseif is_valid_chest(node.name) then -- check for locked chest
				if node_meta:get_string("owner") == pn or
					minetest.check_player_privs(pn, "protection_bypass") then
					return replicator_store_secret(itemstack, secret, pn)
				end
			end
		end
	elseif pointed_thing.type == "object" then -- object pointed
		local luaentity = pointed_thing.ref:get_luaentity()
		local pn = user:get_player_name()
		if  not luaentity or ( luaentity.owner ~= pn and
			not minetest.check_player_privs(pn, "protection_bypass")) or
			not luaentity.key_lock_secret or
			luaentity.key_lock_secret == itemstack:get_meta():get_string("key_lock_secret") then
			return
		end
		itemstack:get_meta():set_string("key_lock_secret", luaentity.key_lock_secret)
		minetest.chat_send_player(pn, S("Lock shape stored"))
		itemstack:add_wear_by_uses(replicator_uses)
		return itemstack
	end
end

local tooldef = {
	description = S("A tool to replicate lock"),
	short_description = S("Lock Replicator"),
	inventory_image = "lock_replica.png",
	wield_image = "lock_replica.png",
	on_place = replicator_on_place,
	on_use = replicator_on_use,
}

if minetest.get_modpath("technic") then
	tooldef.max_charge = max_charge
	technic.register_power_tool("lock_replica:tool", tooldef)
else
	minetest.register_tool("lock_replica:tool", tooldef)
end

minetest.register_craft({
	output = "lock_replica:tool",
	recipe = {
		{"default:tin_ingot", "default:copper_ingot", "default:steel_ingot"},
		{"default:copper_ingot", "", ""},
		{"", "", ""},
	}
})

-- vim: ai:noet:ts=4:sw=4:fdm=indent:syntax=lua
