bridgemaker = {}

local S = minetest.get_translator("bridgemaker")

minetest.register_node("bridgemaker:bridgemaker", {
	tiles = {
        "bridgemaker2.png",
        "bridgemaker2.png",
		"bridgemaker2.png",
        "bridgemaker2.png",
		"bridgemaker2.png",
        "bridgemaker2.png",
	},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	legacy_wallmounted = true,
	walkable = true,
	sunlight_propagates = true,
	description = S("bridgemaker machine ready to go"),
	inventory_image = "bridgemaker.png",
	wield_image = "bridgemaker.png",
	groups = {choppy = 2, cracky = 2},
	--diggable = false,
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -6/16, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -6/16, 0.5}
	},
    on_rightclick = function(pos,node,clicker,itemstack)
        local pram = node.param2
        pram = pram +1
            if pram > 3 then
                pram = 0
            end
        node.param2 = pram
	    minetest.swap_node(pos, node)
	end,
    on_place = function(itemstack, placer, pointed_thing)
        minetest.set_node(pointed_thing.above, {name='bridgemaker:bridgemaker'})
        itemstack:take_item()
        return itemstack
    end,
    on_construct = function(pos, node)
        local meta = minetest.get_meta(pos)
        local count = 8
	    meta:set_int("blockcount", count )  
	    meta:set_string("infotext", tostring(count) )
    end,
    on_punch = function(pos, node, puncher, pointed_thing)
        if puncher:is_player() then
            local meta = minetest.get_meta(pos)
            local pram = node.param2
            local xd = 0
            local zd = 0
            local count = meta:get_int( "blockcount" )
            if pram == 0 then 
                xd = 0
                zd = 1
            end
            if pram == 1 then 
                xd = 1
                zd = 0
            end
            if pram == 2 then 
                xd = 0
                zd = -1
            end
            if pram == 3 then 
                xd = -1
                zd = 0
            end
            local pc = 0
            for n = 1, count  do
                local nxt_node = minetest.get_node({ x = pos.x +xd*n , y = pos.y -1 , z = pos.z + zd*n })
                if nxt_node.name == "ignore" or nxt_node.name =="air" then
                    minetest.set_node({ x = pos.x +xd*n , y = pos.y -1 , z = pos.z + zd*n }, {name = "default:wood"})
                    pc = pc + 1
                else
                    break
                end
            end
            count = count - pc
	        meta:set_int("blockcount", count)  
	        meta:set_string("infotext", tostring(count) )
            if count==0 then  
                minetest.set_node(pos, {name="bridgemaker:empty_machine"})
            end
        end
    end,
})
minetest.register_node("bridgemaker:empty_machine", {
	tiles = {
        "bridgemaker_empty.png",
        "bridgemaker_empty.png",
		"bridgemaker_empty.png",
        "bridgemaker_empty.png",
		"bridgemaker_empty.png",
        "bridgemaker_empty.png",
	},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	legacy_wallmounted = true,
	walkable = true,
	sunlight_propagates = true,
	description = S("bridgemaker empty machine"),
	inventory_image = "bridgemaker_empty.png",
	wield_image = "bridgemaker_empty.png",
	groups = {choppy = 2, cracky = 2},
	--diggable = false,
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -6/16, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, -6/16, 0.5}
	},
    on_place = function(itemstack, placer, pointed_thing)
        minetest.set_node(pointed_thing.above, {name='bridgemaker:empty_machine'})
        itemstack:take_item()
        return itemstack
    end,
})
minetest.register_craft({
	output = "bridgemaker:bridgemaker",
	recipe = {
	{"group:wood","group:wood","group:wood"},
	{"group:wood","bridgemaker:empty_machine","group:wood"},
	{"group:wood","group:wood","group:wood"},
	},
})
minetest.register_craft({
	output = "bridgemaker:empty_machine",
	recipe = {
	{"default:copper_ingot","group:wood","default:copper_ingot"},
	{"default:tin_ingot","default:steel_ingot","default:tin_ingot"},
	{"default:copper_ingot","group:wood","default:copper_ingot"},
	},
})

