skinchooser = {}

minetest.register_node("skinchooser:chooser1", {
	description = "Right clicking this node will launch skinsDB for the hitter",
	tiles = {
        "top1.png",
        "bottom.png",
		"left1.png",
        "right1.png",
		"back1.png",
        "front1.png",
	},
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
          --   X1    Y1     Z1    X2    Y2   Z2
			{-0.10, 0.28, -0.10, 0.10, 0.5, 0.10}, -- head

			{-0.05, 0.25, -0.05, 0.05, 0.28, 0.05}, -- neck

			{-0.19, -0.00, -0.08, 0.19, 0.25, 0.06}, -- body

			{-0.11, -0.15, -0.08, 0.11, -0.00, 0.06}, -- legs hip

			{-0.11, -0.45, -0.04, -0.02, -0.15, 0.05}, -- legs left

			{0.02, -0.45, -0.04, 0.11, -0.15, 0.05}, -- legs right

			{-0.10, -0.50, -0.10, -0.05, -0.45, 0.02}, -- foot left

			{0.05, -0.50, -0.10, 0.10, -0.45, 0.02}, -- foot right

		}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.5}
		}
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.5}
		}
	},

	is_ground_content = false,
	groups = {choppy = 2, cracky = 2},
	diggable = false,
	after_place_node = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("infotext", "Skin Chooser" )
	end,
    on_rightclick = function(pos,node,clicker,itemstack)
        local skins = core.chatcommands["skinsdb"]
        local name = clicker:get_player_name()    
            skins.func(name,"")
	end,
})

minetest.register_node("skinchooser:chooser2", {
	description = "Right clicking this node will launch skinsDB for the hitter",
	tiles = {
        "top10.png",
        "bottom.png",
		"left10.png",
        "right10.png",
		"back10.png",
        "front10.png",
	},
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
          --   X1    Y1     Z1    X2    Y2   Z2
			{-0.10, 0.28, -0.10, 0.10, 0.5, 0.10}, -- head

			{-0.05, 0.25, -0.05, 0.05, 0.28, 0.05}, -- neck

			{-0.19, -0.00, -0.08, 0.19, 0.25, 0.06}, -- body

			{-0.11, -0.15, -0.08, 0.11, -0.00, 0.06}, -- legs hip

			{-0.11, -0.45, -0.04, -0.02, -0.15, 0.05}, -- legs left

			{0.02, -0.45, -0.04, 0.11, -0.15, 0.05}, -- legs right

			{-0.10, -0.50, -0.10, -0.05, -0.45, 0.02}, -- foot left

			{0.05, -0.50, -0.10, 0.10, -0.45, 0.02}, -- foot right

		}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.5}
		}
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.5}
		}
	},

	is_ground_content = false,
	groups = {choppy = 2, cracky = 2},
	diggable = false,
	after_place_node = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("infotext", "Skin Chooser" )
	end,
    on_rightclick = function(pos,node,clicker,itemstack)
        local skins = core.chatcommands["skinsdb"]
        local name = clicker:get_player_name()    
            skins.func(name,"")
	end,
})


minetest.register_abm({
	nodenames = {"skinchooser:chooser1","skinchooser:chooser2"},
	interval = 2.0, -- Run every 2 seconds
	chance = 1, -- Select every 1 in 1 nodes
	action = function(pos, node, active_object_count, active_object_count_wider)
        local random_number = math.random(0, 1)
        node_name = node.name   
        if (random_number == 0) then
            local pram = node.param2
            pram = pram + 1
            if pram == 4 then 
                pram = 0
            end
		    minetest.set_node({x = pos.x, y = pos.y, z = pos.z}, {name = "skinchooser:chooser2"})
            minetest.set_node(pos, {name = "skinchooser:chooser1", param2 = pram})
            local metaA = minetest.get_meta(pos)
			metaA:set_string("infotext", "right-click to change skin" )      
        elseif (random_number == 1) then
            local pram = node.param2
            pram = pram + 1
            if pram == 4 then 
                pram = 0
            end
		    minetest.set_node({x = pos.x, y = pos.y, z = pos.z}, {name = "skinchooser:chooser1"})
            minetest.set_node(pos, {name = "skinchooser:chooser2", param2 = pram})
            local metaA = minetest.get_meta(pos)
			metaA:set_string("infotext", "right-click to change skin" )                     
        end
	end
})



