minetest.register_on_chat_message(function(name, message)
    if message:lower():match("^color me!?$") then
        minetest.show_formspec(name, "colorme:colorizer", table.concat({
            "size[6,4]",
            "formspec_version[1]",
            "label[1,0.5;Choose a color]",
            "dropdown[1,1.5;4,1;color_select;Blue,Red,White,Yellow,Cyan,Green,Purple;1]",
            "button[1,3;4,1;confirm;Apply Color]"
        }))
    end
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "colorme:colorizer" then return end
    if not fields.confirm or not fields.color_select then return end

    local color_map = {
        Blue = "#0000FF",
        Red = "#FF0000",
        White = "#FFFFFF",
        Yellow = "#FFFF00",
        Cyan = "#00FFFF",
        Green = "#00FF00",
        Purple = "#FF00FF"
    }

    local wielded = player:get_wielded_item()
    if wielded:is_empty() then
        minetest.chat_send_player(player:get_player_name(), "Hold an item to color it!")
        return
    end

    local new_stack = ItemStack(wielded)
    local meta = new_stack:get_meta()
    meta:set_string("color", color_map[fields.color_select])

    player:set_wielded_item(new_stack)
end)