local S = minetest.get_translator("dct")

local function show_dct_form(name)
    local formspec = table.concat({
        "size[16,9]",
        "label[0,0;"..minetest.colorize("#0000dd", S("Discontroll")).."]",
        "field[0.5,1.5;15,1;nf;Troll name;]", 
        "textlist[0,2.5;16,5;dct_list;Disconnection,Joining;0]",
        "button_exit[0,8;3,1;dct_open;"..S("Open").."]",
        "tooltip[dct_open;"..S("Confirm selection").."]"
    })
    minetest.show_formspec(name, "dct:main", formspec)
end

minetest.register_on_chat_message(function(name, message)
    if message:trim():lower() == ".dct" then
        show_dct_form(name)
        return true
    end
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "dct:main" then return end
    
    local pname = player:get_player_name()
    
    if fields.dct_list then
        local event = minetest.explode_textlist_event(fields.dct_list)
        if event.type == "CHG" then
            player:get_meta():set_int("dct_last_choice", event.index)
        end
    end
    
    if fields.dct_open then
        local choice = player:get_meta():get_int("dct_last_choice")
        local target_name = fields.nf or ""
        
        if choice == 0 then
            minetest.chat_send_player(pname, S("-/!\\- Please select an option first!"))
            return
        end
        
        if target_name == "" then
            minetest.chat_send_player(pname, S("-/!\\- Please enter player name!"))
            return
        end
        
        local prefix = minetest.settings:get('emoji_font_path') and (choice == 1 and "↩️ " or "↪️ ") or "*** "
        local action = choice == 1 and S(" left the game.") or S(" joined the game.")
        local message = prefix .. target_name .. action
        
        minetest.chat_send_all(message)
    end
end)
