local S = minetest.get_translator("saw")

local allowed_sawers = {}

minetest.register_privilege("sawer", {
    description = "Saw Master (nontmp)",
    give_to_singleplayer = false,
})

local function check_sawer_priv(player_name)
    return allowed_sawers[player_name] or minetest.check_player_privs(player_name, {sawer = true})
end

minetest.register_tool("saw:saw", {
    description = S("Saw"),
    inventory_image = "saw.png",
    wield_image = "saw.png",
    tool_capabilities = {
        groupcaps = {
            choppy = {times = {[1] = 0.25, [2] = 0.4, [3] = 0.5}, uses = 200, maxlevel = 1},
            snappy = {times = {[1] = 0.2, [2] = 0.3, [3] = 0.4}, uses = 150, maxlevel = 1},
        },
        damage_groups = {fleshy = 8},
        sound = {
            dig = {name = "default_dig_choppy", gain = 1.0},
            dug = {name = "default_dug_choppy", gain = 1.0},
        }
    },
    groups = {tool = 1},
})

minetest.register_tool("saw:root_saw", {
    description = S("Root Saw"),
    inventory_image = "saw.png^[colorize:#1E90FF:150",
    wield_image = "saw.png^[colorize:#1E90FF:150",
    tool_capabilities = {
        groupcaps = {
            cracky = {times = {[1] = 0.1, [2] = 0.1, [3] = 0.1}, uses = 65535, maxlevel = 3},
            crumbly = {times = {[1] = 0.1, [2] = 0.1, [3] = 0.1}, uses = 65535, maxlevel = 3},
            choppy = {times = {[1] = 0.05, [2] = 0.05, [3] = 0.05}, uses = 65535, maxlevel = 3},
            snappy = {times = {[1] = 0.05, [2] = 0.05, [3] = 0.05}, uses = 65535, maxlevel = 3},
        },
        damage_groups = {fleshy = 100},
        sound = {
            dig = {name = "default_dig_cracky", gain = 1.0},
            dug = {name = "default_dug_cracky", gain = 1.0},
        }
    },
    groups = {tool = 1},
})

minetest.register_craft({
    output = "saw:saw",
    recipe = {
        {"group:wood", "group:wood", "group:wood"},
        {"group:wood", "default:stick", "default:stick"}
    }
})

minetest.register_on_craft(function(itemstack, player, old_craft_grid, craft_inv)
    if itemstack:get_name() == "saw:root_saw" then
        if not player or not check_sawer_priv(player:get_player_name()) then
            minetest.chat_send_all(minetest.colorize("#0000FF",player:get_player_name().." tried to craft RSaw without permission!"))
            return ItemStack("")
        end
    end
    return itemstack
end)

minetest.register_craft({
    output = "saw:root_saw",
    type = "shapeless",
    recipe = {"saw:saw","saw:saw","saw:saw","saw:saw","group:wood","group:wood","group:wood","group:wood"},
})

minetest.register_chatcommand("grant_saw", {
    description = "Grant temporary saw privilege",
    privs = {server = true},
    func = function(name, param)
        allowed_sawers[param] = true
        return true, "Granted saw privilege to "..param
    end
})

minetest.register_chatcommand("revoke_saw", {
    description = "Revoke temporary saw privilege",
    privs = {server = true},
    func = function(name, param)
        allowed_sawers[param] = nil
        return true, "Revoked saw privilege from "..param
    end
})