return function(on_construct_or_destruct)
  local S = core.get_translator(core.get_current_modname())
  local drain_time = 3600.0  -- drain time per water_level


  local function place_reservoir(pos, reservoir_type, water_level, start_drain)
    core.swap_node(pos, {name = reservoir_type, param2 = water_level})
    local meta = core.get_meta(pos)

    meta:set_int("water", water_level)
    meta:set_string("infotext", "Water Reservoir (" .. math.floor((water_level / 63) * 100) .. "%)")

    if start_drain then
      core.get_node_timer(pos):start(drain_time)
    else
      core.get_node_timer(pos):stop()
    end

    on_construct_or_destruct(pos, reservoir_type, start_drain)
  end


  local function new_water_level(water, change)
    local new = math.min(math.max(water + change, 0), 63)
    if new == water then
      return nil
    end
    return new
  end


  local function reservoir_set_water(pos, node, clicker, itemstack)
    local meta = core.get_meta(pos)
    local water = meta:get_int("water") or 0
    local reservoir_type = "irrigation:water_reservoir"

    if clicker and clicker:is_player() and itemstack then
      local wield_item = itemstack:get_name()

      if wield_item ~= "bucket:bucket_water" and wield_item ~= "bucket:bucket_river_water" then
        return itemstack
      end

      local water_level = new_water_level(water, 16)

      if not water_level then
        return itemstack -- reservoir full
      end

      place_reservoir(pos, reservoir_type .. "_active", water_level, true)
      itemstack:replace("bucket:bucket_empty")

      return itemstack
    end

    -- timer drain
    local water_level = new_water_level(water, -8)

    if water_level == 0 then
      place_reservoir(pos, reservoir_type, water_level, false)
      return
    end

    place_reservoir(pos, reservoir_type .. "_active", water_level, true)
  end


  core.register_alias("irrigation:water_reservoir_holding", "irrigation:water_reservoir_active")

  core.register_node("irrigation:water_reservoir_active", {
    drawtype = "glasslike_framed",
    paramtype2 = "glasslikeliquidlevel",
    backface_culling = false,
    short_description = S("Water Reservoir"),
    description = S("Waters soil for up to 8 hours"),
    groups = {cracky = 3, water = 1, not_in_creative_inventory = 1},
    tiles = {"irrigation_reservoir.png"},
    drop = "irrigation:water_reservoir",
    use_texture_alpha = "blend",
    special_tiles = {core.registered_nodes["default:water_source"].tiles[1]},
    on_rightclick = reservoir_set_water,
    on_timer = reservoir_set_water,
    on_destruct = function(pos)
      core.get_node_timer(pos):stop()
    end,
    after_destruct = function(pos, old_node)
      on_construct_or_destruct(pos, old_node.name, false)
    end
  })

  core.register_node("irrigation:water_reservoir", {
    drawtype = "glasslike_framed",
    paramtype2 = "glasslikeliquidlevel",
    backface_culling = false,
    short_description = S("Water Reservoir"),
    description = S("Waters soil for up to 8 hours"),
    groups = {cracky = 3},
    tiles = {"irrigation_reservoir.png"},
    drop = "irrigation:water_reservoir",
    use_texture_alpha = "blend",
    on_rightclick = reservoir_set_water,
  })

  core.register_craft({
    output = "irrigation:water_reservoir",
    recipe = {
      {"default:glass",     "",              "default:glass"},
      {"default:iron_lump", "",              "default:iron_lump"},
      {"default:glass",     "default:glass", "default:glass"}
    }
  })
end
-- MIT © 2026 monk https://github.com/monk-afk/irrigation
