minetest.register_node("instruments:drum", {
	description = "Drum",

	tiles = { 
		"drum_top.png",
		"default_acacia_tree.png",
		"default_acacia_tree.png",
		"default_acacia_tree.png",
		"default_acacia_tree.png",
		"default_acacia_tree.png",
		"default_acacia_tree.png",
	},
	groups = {oddly_breakable_by_hand = 3},
	paramtype = "light",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-0.3, -0.50, -0.3, 0.3, 0.35, 0.3}
		}
	},
	on_rightclick = function()
		minetest.sound_play("drum_smack", {gain = 1})
	end,
})

minetest.register_tool("instruments:drum_stick", {
	description = "Drumstick",
	inventory_image = "drum_stick.png",
	wield_image = "drum_stick.png",
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type == 'node' then
			local node = minetest.get_node(minetest.get_pointed_thing_position(pointed_thing))
			if node.name == "instruments:drum" then
				minetest.sound_play("drum_strike", {gain = 1})
			end
		end
	end
})
