-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
local transformer={}

transformer.onConstruct=function(pos)
	local meta=minetest.get_meta(pos)
	industrialtest.api.addPowerStorage(meta,config.upperFlow,0,"aaaaaa")
end

transformer.onTimer=function(pos,elapsed)
	local meta=minetest.get_meta(pos)
	local node=minetest.get_node(pos)
	local neighbourPositions={
		vector.offset(pos,-1,0,0),
		vector.offset(pos,1,0,0),
		vector.offset(pos,0,-1,0),
		vector.offset(pos,0,1,0),
		vector.offset(pos,0,0,-1),
		vector.offset(pos,0,0,1)
	}
	local upperPowerDistribution=0
	local lowerPowerDistribution=0

	for key,value in ipairs(neighbourPositions) do
		local normalized=industrialtest.api.normalizeSide(pos,key)
		if industrialtest.api.hasPowerStorage(minetest.get_meta(value)) and industrialtest.api.isPowerOutput(meta,normalized) then
			if normalized==5 then
				upperPowerDistribution=config.upperFlow
			else
				lowerPowerDistribution=lowerPowerDistribution+1
			end
		else
			neighbourPositions[key]=0
		end
	end
	if lowerPowerDistribution>0 then
		lowerPowerDistribution=math.floor(industrialtest.internal.clamp(math.min(config.upperFlow,meta:get_int("industrialtest.powerAmount"))/lowerPowerDistribution,0,config.lowerFlow))
	end

	local roomAvailable=false
	for key,value in ipairs(neighbourPositions) do
		if value~=0 then
			local neighbourMeta=minetest.get_meta(value)
			local normalized=industrialtest.api.normalizeSide(pos,key)
			if normalized==5 then
				if meta:get_int("industrialtest.powerAmount")==config.upperFlow then
					industrialtest.api.transferPower(meta,neighbourMeta,config.upperFlow)
				end
			else
				industrialtest.api.transferPower(meta,neighbourMeta,lowerPowerDistribution)
			end
			if not industrialtest.api.isFullyCharged(neighbourMeta) then
				roomAvailable=true
			end
		end
	end

	meta:set_string("industrialtest.ioConfig","aaaaaa")

	return (meta:get_int("industrialtest.powerAmount")>0 and roomAvailable)
end

transformer.onPowerFlow=function(pos,side)
	industrialtest.api.changeIoConfig(minetest.get_meta(pos),industrialtest.api.normalizeSide(pos,side),"i")
	minetest.get_node_timer(pos):start(industrialtest.updateDelay)
end

local function registerTransformer(config)
	local definition={
		description=config.displayName,
		tiles={
			config.machineBlockTexture.."^industrialtest_"..config.name.."_side.png",
			config.machineBlockTexture.."^industrialtest_"..config.name.."_side.png",
			config.machineBlockTexture.."^industrialtest_"..config.name.."_side.png",
			config.machineBlockTexture.."^industrialtest_"..config.name.."_side.png",
			config.machineBlockTexture.."^industrialtest_"..config.name.."_side.png",
			config.machineBlockTexture.."^industrialtest_"..config.name.."_front.png"
		},
		paramtype2="facedir",
		legacy_facedir_simple=true,
		drop=(config.requiresWrench and "industrialtest:machine_block" or "industrialtest:"..config.name),
		on_construct=transformer.onConstruct,
		on_timer=transformer.onTimer,
		_industrialtest_onPowerFlow=transformer.onPowerFlow
	}
	if industrialtest.mtgAvailable then
		definition.groups={cracky=2}
		definition.sounds=(config.sounds=="metal" and default.node_sound_metal_defaults() or default.node_sound_wood_defaults())
	elseif industrialtest.mclAvailable then
		definition.groups={pickaxey=1}
		definition.sounds=(config.sounds=="metal" and mcl_sounds.node_sound_metal_defaults() or mcl_sounds.node_sound_wood_defaults())
		definition._mcl_blast_resistance=3
		definition._mcl_hardness=3.5
	end
	definition.groups._industrialtest_hasPowerInput=1
	definition.groups._industrialtest_hasPowerOutput=1
	definition.groups._industrialtest_wrenchUnmountable=1
	minetest.register_node("industrialtest:"..config.name,definition)
end

registerTransformer({
	name="lv_transformer",
	displayName="LV Transformer",
	machineBlockTexture="industrialtest_wood_machine_block.png",
	requiresWrench=false,
	lowerFlow=industrialtest.api.lvPowerFlow,
	upperFlow=industrialtest.api.mvPowerFlow,
	sounds="wood"
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:lv_transformer",
	recipe={
		{"group:wood","industrialtest:insulated_tin_cable","group:wood"},
		{industrialtest.elementKeys.copperIngot,industrialtest.elementKeys.copperIngot,industrialtest.elementKeys.copperIngot},
		{"group:wood","industrialtest:insulated_copper_cable","group:wood"}
	}
})

registerTransformer({
	name="mv_transformer",
	displayName="MV Transformer",
	machineBlockTexture="industrialtest_machine_block.png",
	requiresWrench=true,
	lowerFlow=industrialtest.api.mvPowerFlow,
	upperFlow=industrialtest.api.hvPowerFlow,
	sounds="metal"
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:mv_transformer",
	recipe={
		{"industrialtest:insulated_copper_cable"},
		{"industrialtest:machine_block"},
		{"industrialtest:insulated_gold_cable"}
	}
})

registerTransformer({
	name="hv_transformer",
	displayName="HV Transformer",
	machineBlockTexture="industrialtest_machine_block.png",
	requiresWrench=true,
	lowerFlow=industrialtest.api.hvPowerFlow,
	upperFlow=industrialtest.api.evPowerFlow,
	sounds="metal"
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:hv_transformer",
	recipe={
		{"","industrialtest:insulated_iron_cable",""},
		{"industrialtest:electronic_circuit","industrialtest:mv_transformer","industrialtest:energy_crystal"},
		{"","industrialtest:insulated_iron_cable",""}
	}
})

registerTransformer({
	name="ev_transformer",
	displayName="EV Transformer",
	machineBlockTexture="industrialtest_machine_block.png",
	requiresWrench=true,
	lowerFlow=industrialtest.api.evPowerFlow,
	upperFlow=industrialtest.api.ivPowerFlow,
	sounds="metal"
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:ev_transformer",
	recipe={
		{"","industrialtest:insulated_iron_cable",""},
		{"industrialtest:advanced_electronic_circuit","industrialtest:hv_transformer","industrialtest:lapotron_crystal"},
		{"","industrialtest:insulated_iron_cable",""}
	}
})
