-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.PowerStorage=table.copy(industrialtest.ElectricMachine)
industrialtest.internal.unpackTableInto(industrialtest.PowerStorage,{
	facedir=true,
	storageLists={
		"charged",
		"discharged"
	},
	powerLists={
		{
			list="charged",
			direction="o"
		},
		{
			list="discharged",
			direction="i"
		}
	},
	hasPowerInput=true,
	hasPowerOutput=true,
	ioConfig="iiiioi"
})

function industrialtest.PowerStorage.onConstruct(self,pos)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	inv:set_size("charged",1)
	inv:set_size("discharged",1)
	industrialtest.ElectricMachine.onConstruct(self,pos)
end

function industrialtest.PowerStorage.getFormspec(self,pos)
	local parentFormspec=industrialtest.ElectricMachine.getFormspec(self,pos)
	local meta=minetest.get_meta(pos)
	local charged=meta:get_int("industrialtest.powerAmount")/meta:get_int("industrialtest.powerCapacity")
	local formspec={
		"list[context;charged;1,2.5;1,1]",
		industrialtest.internal.getItemSlotBg(1,2.5,1,1),
		"label[0.9,3.9;"..S("Charge").."]",
		"list[context;discharged;3,2.5;1,1]",
		industrialtest.internal.getItemSlotBg(3,2.5,1,1),
		"label[2.7,3.9;"..S("Discharge").."]",
		self.createPowerIndicatorWidget(charged,9,1),
		"listring[context;charged]",
		"listring[context;discharged]"
	}
	return parentFormspec..table.concat(formspec,"")
end

industrialtest.BatBox=table.copy(industrialtest.PowerStorage)
industrialtest.internal.unpackTableInto(industrialtest.BatBox,{
	name="industrialtest:batbox",
	description=S("BatBox"),
	tiles={
		"industrialtest_wood_machine_block.png",
		"industrialtest_wood_machine_block.png",
		"industrialtest_wood_machine_block.png",
		"industrialtest_wood_machine_block.png",
		"industrialtest_wood_machine_block.png",
		"industrialtest_wood_machine_block.png^industrialtest_batbox_front.png"
	},
	sounds="wood",
	capacity=25000,
	flow=industrialtest.api.lvPowerFlow
})

industrialtest.BatBox:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:batbox",
	recipe={
		{"group:wood","industrialtest:insulated_tin_cable","group:wood"},
		{"industrialtest:re_battery","industrialtest:re_battery","industrialtest:re_battery"},
		{"group:wood","group:wood","group:wood"}
	}
})

industrialtest.CESU=table.copy(industrialtest.PowerStorage)
industrialtest.internal.unpackTableInto(industrialtest.CESU,{
	name="industrialtest:cesu",
	description=S("CESU"),
	tiles={
		"industrialtest_bronze_machine_block.png",
		"industrialtest_bronze_machine_block.png",
		"industrialtest_bronze_machine_block.png",
		"industrialtest_bronze_machine_block.png",
		"industrialtest_bronze_machine_block.png",
		"industrialtest_bronze_machine_block.png^industrialtest_cesu_front.png"
	},
	sounds="metal",
	capacity=400000,
	flow=industrialtest.api.mvPowerFlow
})

industrialtest.CESU:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:cesu",
	recipe={
		{"industrialtest:bronze_plate","industrialtest:insulated_copper_cable","industrialtest:bronze_plate"},
		{"industrialtest:advanced_re_battery","industrialtest:advanced_re_battery","industrialtest:advanced_re_battery"},
		{"industrialtest:bronze_plate","industrialtest:bronze_plate","industrialtest:bronze_plate"}
	}
})

industrialtest.MFE=table.copy(industrialtest.PowerStorage)
industrialtest.internal.unpackTableInto(industrialtest.MFE,{
	name="industrialtest:mfe",
	description=S("MFE"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_mfe_front.png"
	},
	sounds="metal",
	requiresWrench=true,
	capacity=3000000,
	flow=industrialtest.api.hvPowerFlow
})

industrialtest.MFE:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:mfe",
	recipe={
		{"industrialtest:insulated_gold_cable","industrialtest:energy_crystal","industrialtest:insulated_gold_cable"},
		{"industrialtest:energy_crystal","industrialtest:machine_block","industrialtest:energy_crystal"},
		{"industrialtest:insulated_gold_cable","industrialtest:energy_crystal","industrialtest:insulated_gold_cable"}
	}
})


industrialtest.MFSU=table.copy(industrialtest.PowerStorage)
industrialtest.internal.unpackTableInto(industrialtest.MFSU,{
	name="industrialtest:mfsu",
	description=S("MFSU"),
	tiles={
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png^industrialtest_mfsu_front.png"
	},
	sounds="metal",
	requiresWrench=true,
	capacity=30000000,
	flow=industrialtest.api.evPowerFlow
})

industrialtest.MFSU:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:mfsu",
	recipe={
		{"industrialtest:lapotron_crystal","industrialtest:advanced_electronic_circuit","industrialtest:lapotron_crystal"},
		{"industrialtest:lapotron_crystal","industrialtest:mfe","industrialtest:lapotron_crystal"},
		{"industrialtest:lapotron_crystal","industrialtest:advanced_machine_block","industrialtest:lapotron_crystal"}
	}
})
