-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.ToolWorkshop=table.copy(industrialtest.ActivatedElectricMachine)
industrialtest.internal.unpackTableInto(industrialtest.ToolWorkshop,{
	name="industrialtest:tool_workshop",
	description=S("Tool Workshop"),
	tiles={
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png",
		"industrialtest_advanced_machine_block.png^industrialtest_tool_workshop_front.png",
	},
	sounds="metal",
	requiresWrench=true,
	facedir=true,
	storageLists={
		"src",
		"upgrades",
		"powerStorage"
	},
	powerLists={
		{
			list="powerStorage",
			direction="i"
		}
	},
	active={
		tiles={
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png",
			"industrialtest_advanced_machine_block.png^industrialtest_tool_workshop_front_active.png",
		}
	},
	capacity=15000,
	flow=industrialtest.api.hvPowerFlow,
	hasPowerInput=true,
	ioConfig="iiiiii",
	_opPower=10000,
	_efficiency=200
})

function industrialtest.ToolWorkshop.onConstruct(self,pos)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	inv:set_size("powerStorage",1)
	inv:set_size("src",1)
	inv:set_size("upgrades",4)
	industrialtest.ActivatedElectricMachine.onConstruct(self,pos)
end

function industrialtest.ToolWorkshop.getFormspec(self,pos)
	local parentFormspec=industrialtest.ActivatedElectricMachine.getFormspec(self,pos)
	local meta=minetest.get_meta(pos)
	local powerPercent=meta:get_int("industrialtest.powerAmount")/meta:get_int("industrialtest.powerCapacity")*100
	local formspec={
		"list[context;powerStorage;3.7,3.7;1,1;0]",
		industrialtest.internal.getItemSlotBg(3.7,3.7,1,1),
		(powerPercent>0 and "image[3.7,2.5;1,1;industrialtest_gui_electricity_bg.png^[lowpart:"..powerPercent..":industrialtest_gui_electricity_fg.png]"
		 or "image[3.7,2.5;1,1;industrialtest_gui_electricity_bg.png]"),
		"list[context;src;5.9,3.2;1,1;0]",
		industrialtest.internal.getItemSlotBg(5.9,3.2,1,1),
		"list[context;upgrades;9,0.9;1,4]",
		industrialtest.internal.getItemSlotBg(9,0.9,1,4),
		"listring[context;src]"
	}
	return parentFormspec..table.concat(formspec,"")
end

function industrialtest.ToolWorkshop.allowMetadataInventoryMove(self,pos,fromList,fromIndex,toList,toIndex,count)
	if toList=="src" then
		local meta=minetest.get_meta(pos)
		local inv=meta:get_inventory()
		local movedItemStack=inv:get_stack(fromList,fromIndex)
		if not self.isTool(movedItemStack) then
			return 0
		end
	end
	return industrialtest.ActivatedElectricMachine.allowMetadataInventoryMove(self,pos,fromList,fromIndex,toList,toIndex,count)
end

function industrialtest.ToolWorkshop.allowMetadataInventoryPut(self,pos,listname,index,stack,player)
	if listname=="tool" and not self.isTool(stack) then
		return 0
	end
	return industrialtest.ActivatedElectricMachine.allowMetadataInventoryPut(self,pos,listname,index,stack,player)
end

function industrialtest.ToolWorkshop.onMetadataInventoryMove(self,pos,fromList,fromIndex,toList,toIndex,count)
	self:triggerIfNeeded(pos)
	industrialtest.ActivatedElectricMachine.onMetadataInventoryMove(self,pos,fromList,fromIndex,toList,toIndex,count)
end

function industrialtest.ToolWorkshop.onMetadataInventoryPut(self,pos,listname,index,stack)
	self:triggerIfNeeded(pos)
	industrialtest.ActivatedElectricMachine.onMetadataInventoryPut(self,pos,listname,index,stack)
end

function industrialtest.ToolWorkshop.shouldActivate(self,pos)
	local meta=minetest.get_meta(pos)

	local requiredPower=industrialtest.api.getMachineSpeed(meta)*self._opPower
	if meta:get_int("industrialtest.powerAmount")<requiredPower then
		return false
	end

	local inv=meta:get_inventory()
	local toolSlot=inv:get_stack("src",1)
	return not toolSlot:is_empty() and self.isTool(toolSlot) and toolSlot:get_wear()>0
end

function industrialtest.ToolWorkshop.shouldDeactivate(self,pos)
	return not self:shouldActivate(pos)
end

function industrialtest.ToolWorkshop.activeUpdate(self,pos,elapsed,meta,inv)
	local toolSlot=inv:get_stack("src",1)
	local speed=industrialtest.api.getMachineSpeed(meta)

	local requiredPower=industrialtest.api.getMachineSpeed(meta)*self._opPower
	local removed=math.min(toolSlot:get_wear(),speed*self._efficiency)
	toolSlot:set_wear(toolSlot:get_wear()-removed)
	inv:set_stack("src",1,toolSlot)
	industrialtest.api.addPower(meta,-requiredPower)

	return true
end

function industrialtest.ToolWorkshop.isTool(stack)
	local def=minetest.registered_tools[stack:get_name()]
	if not def or industrialtest.api.hasPowerStorage(stack:get_meta())then
		return false
	end
	return def.groups and (def.groups.pickaxe or def.groups.sword or def.groups.hoe or def.groups.tool or def.groups.weapon or def.groups.shovel or def.groups.axe)
end

industrialtest.ToolWorkshop:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:tool_workshop",
	recipe={
		{industrialtest.elementKeys.copperIngot,industrialtest.elementKeys.ironPickaxe,industrialtest.elementKeys.copperIngot},
		{"","industrialtest:advanced_machine_block",""},
		{industrialtest.elementKeys.ironIngot,industrialtest.elementKeys.ironIngot,industrialtest.elementKeys.ironIngot}
	}
})
