-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.ActivatedElectricTool=table.copy(industrialtest.ElectricTool)

function industrialtest.ActivatedElectricTool.createDefinitionTable(self)
	local def=industrialtest.ElectricTool.createDefinitionTable(self)

	def.groups._industrialtest_activatedElectricTool=1
	def.tool_capabilities.full_punch_interval=self.fullPunchInterval
	if self.digs then
		self:defineToolCapabilities(def,nil,self.digSpeed)
	end
	if self.hits then
		def.tool_capabilities.damage_groups={}
		for _,hitType in ipairs(self.hits) do
			def.tool_capabilities.damage_groups[hitType]=1
		end
	end

	return def
end

function industrialtest.ActivatedElectricTool.createActiveDefinitionTable(self)
	local def=self:createDefinitionTable()

	if self.digs or self.hits then
		self:defineToolCapabilities(def,self.active.times,self.active.digSpeed)
	end

	def.groups.not_in_creative_inventory=1

	def.after_use=function(itemstack,user,node,digparams)
		if self:afterUse(itemstack,user,node,digparams) then
			return itemstack
		end
		return nil
	end

	return def
end

function industrialtest.ActivatedElectricTool.register(self)
	industrialtest.ElectricTool.register(self)
	local def=self:createActiveDefinitionTable()
	minetest.register_tool(self.name.."_active",def)
end

function industrialtest.ActivatedElectricTool.beforeUse(self,itemstack,node)
	local def=itemstack:get_definition()
	if self:canActivate(itemstack,node) then
		if not self.isActive(itemstack) then
			itemstack:set_name(itemstack:get_name().."_active")
		end
		return true
	else
		itemstack:set_name(self.name)
	end
	return false
end

function industrialtest.ActivatedElectricTool.afterUse(self,itemstack,user,node,digparams)
	local meta=itemstack:get_meta()
	industrialtest.api.addPowerToItem(itemstack,-self:getOpPower(itemstack))
	return true
end

function industrialtest.ActivatedElectricTool.canActivate(self,itemstack,node)
	local meta=itemstack:get_meta()
	return meta:get_int("industrialtest.powerAmount")>=self:getOpPower(itemstack)
end

function industrialtest.ActivatedElectricTool.isActive(itemstack)
	return string.sub(itemstack:get_name(),-string.len("_active"),-1)=="_active"
end

function industrialtest.ActivatedElectricTool.defineToolCapabilities(self,def,times,digSpeed)
	if industrialtest.mtgAvailable then
		if self.digs then
			def.tool_capabilities.groupcaps={}
			for _,digType in ipairs(self.digs) do
				def.tool_capabilities.groupcaps[digType]={
					times=times,
					maxlevel=self.digLevel+1
				}
				if digType=="choppy" then
					def.groups.axe=1
				elseif digType=="cracky" then
					def.groups.pickaxe=1
				elseif digType=="crumbly" then
					def.groups.shovel=1
				elseif digType=="hoey" then
					def.groups.hoe=1
				end
			end
		end
		if self.hits then
			for _,hitType in ipairs(self.hits) do
				if hitType=="fleshy" then
					def.groups.sword=1
				end
			end
		end
	elseif industrialtest.mclAvailable then
		if self.digs then
			local digTypeMapping={
				choppy={"axey"},
				cracky={"pickaxey"},
				crumbly={"shovely"},
				hoey={"hoey"},
				snappy={"swordy","swordy_cobweb"}
			}
			def.groups.dig_speed_class=self.digSpeedClass
			def._mcl_diggroups={}
			for _,digType in ipairs(self.digs) do
				for _,mappedDigType in ipairs(digTypeMapping[digType]) do
					def._mcl_diggroups[mappedDigType]={
						speed=digSpeed,
						level=5-self.digLevel,
						uses=-1
					}
				end
			end
		end
		if self.hits then
			for _,hitType in ipairs(self.hits) do
				if hitType=="fleshy" then
					def.groups.weapon=1
					def.groups.sword=1
				end
			end
		end
	end
end

minetest.register_on_punchnode(function(pos,node,user)
	if not user then
		return
	end

	local itemstack=user:get_wielded_item()
	local def=itemstack:get_definition()
	if def and def._industrialtest_self and def.groups and def.groups._industrialtest_activatedElectricTool and
		def._industrialtest_self:beforeUse(itemstack,node) then
		user:set_wielded_item(itemstack)
	end
end)
