-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.Generator=table.copy(industrialtest.ActivatedElectricMachine)
industrialtest.internal.unpackTableInto(industrialtest.Generator,{
	name="industrialtest:generator",
	description=S("Generator"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_iron_furnace_front.png"
	},
	sounds="metal",
	facedir=true,
	storageLists={
		"src",
		"charged"
	},
	active={
		tiles={
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png^industrialtest_iron_furnace_front_active.png"
		},
		lightSource=8
	},
	capacity=7000,
	flow=industrialtest.api.lvPowerFlow,
	ioConfig="oooooo",
	hasPowerOutput=true,
	powerLists={
		{
			list="charged",
			direction="o"
		}
	}
})

function industrialtest.Generator.onConstruct(self,pos)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	inv:set_size("charged",1)
	inv:set_size("src",1)
	meta:set_float("fuelTime",0)
	meta:set_float("maxFuelTime",1)
	industrialtest.ActivatedElectricMachine.onConstruct(self,pos)
end

function industrialtest.Generator.getFormspec(self,pos)
	local parentFormspec=industrialtest.ActivatedElectricMachine.getFormspec(self,pos)
	local meta=minetest.get_meta(pos)
	local fuelPercent=meta:get_float("fuelTime")/meta:get_float("maxFuelTime")*100
	local charged=meta:get_int("industrialtest.powerAmount")/meta:get_int("industrialtest.powerCapacity")
	local formspec={
		"list[context;charged;4.7,1.8;1,1]",
		industrialtest.internal.getItemSlotBg(4.7,1.8,1,1),
		(fuelPercent>0 and "image[4.7,2.8;1,1;default_furnace_fire_bg.png^[lowpart:"..fuelPercent..":default_furnace_fire_fg.png]"
		 or "image[4.7,2.8;1,1;default_furnace_fire_bg.png]"),
		"list[context;src;4.7,3.9;1,1]",
		industrialtest.internal.getItemSlotBg(4.7,3.9,1,1),
		self.createPowerIndicatorWidget(charged,9,1),
		"listring[context;src]"
	}
	return parentFormspec..table.concat(formspec,"")
end

function industrialtest.Generator.onMetadataInventoryPut(self,pos,listname,index,stack)
	self:triggerIfNeeded(pos)
	industrialtest.ActivatedElectricMachine.onMetadataInventoryPut(self,pos,listname,index,stack)
end

function industrialtest.Generator.activeUpdate(self,pos,elapsed,meta,inv)
	local chargedSlot=inv:get_stack("charged",1)
	local fuelSlot=inv:get_stack("src",1)
	local shouldUpdateFormspec=false

	if fuelSlot:get_count()>0 and meta:get_float("fuelTime")<=0 and not industrialtest.api.isFullyCharged(meta) then
		local output,after=minetest.get_craft_result({
			method="fuel",
			width=1,
			items={fuelSlot}
		})
		if output.time>0 then
			meta:set_float("fuelTime",output.time)
			meta:set_float("maxFuelTime",output.time)
			inv:set_stack("src",1,after.items[1])
		end
	end

	if meta:get_float("fuelTime")>0 then
		meta:set_float("fuelTime",meta:get_float("fuelTime")-elapsed)
		industrialtest.api.addPower(meta,200)
		shouldUpdateFormspec=true
	end

	return shouldUpdateFormspec
end

function industrialtest.Generator.shouldActivate(self,pos)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	local fuelSlot=inv:get_stack("src",1)

	if fuelSlot:get_count()>0 and not industrialtest.api.isFullyCharged(meta) then
		local output,after=minetest.get_craft_result({
			method="fuel",
			width=1,
			items={fuelSlot}
		})
		if output.time>0 then
			return true
		end
	end

	return false
end

function industrialtest.Generator.shouldDeactivate(self,pos)
	local meta=minetest.get_meta(pos)

	if meta:get_float("fuelTime")>0 then
		return false
	end

	local inv=meta:get_inventory()
	local fuelSlot=inv:get_stack("src",1)
	if fuelSlot:get_count()>0 and not industrialtest.api.isFullyCharged(meta) then
		local output,after=minetest.get_craft_result({
			method="fuel",
			width=1,
			items={fuelSlot}
		})
		if output.time>0 then
			return false
		end
	end

	return true
end

industrialtest.Generator:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:generator",
	recipe={
		{"industrialtest:re_battery"},
		{"industrialtest:machine_block"},
		{industrialtest.elementKeys.furnace}
	}
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:generator",
	recipe={
		{"","industrialtest:re_battery",""},
		{"industrialtest:refined_iron_ingot","industrialtest:refined_iron_ingot","industrialtest:refined_iron_ingot"},
		{"","industrialtest:iron_furnace",""}
	}
})

