-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.ActivatedMachine=table.copy(industrialtest.Machine)

function industrialtest.ActivatedMachine.canUpdate(self,pos)
	return self:shouldActivate(pos)
end

function industrialtest.ActivatedMachine.onTimer(self,pos,elapsed)
	local result=industrialtest.Machine.onTimer(self,pos,elapsed)

	if self:shouldActivate(pos) then
		self:activate(pos)
		return false
	end

	return result
end

function industrialtest.ActivatedMachine.register(self)
	industrialtest.Machine.register(self)

	local def=self:createActiveDefinitionTable()
	minetest.register_node(self.name.."_active",def)
end

function industrialtest.ActivatedMachine.createActiveDefinitionTable(self)
	local def=self:createDefinitionTable()
	def.description=nil
	def.drop=def.drop or self.name

	if self.active then
		def.tiles=self.active.tiles or def.tiles
		def.light_source=self.active.lightSource
	end

	def.on_timer=function(pos,elapsed)
		return self:activeOnTimer(pos,elapsed)
	end

	if industrialtest.mclAvailable then
		def.groups.not_in_creative_inventory=1
		def._doc_items_create_entry=false
	end

	return def
end

function industrialtest.ActivatedMachine.activate(self,pos)
	minetest.swap_node(pos,{
		name=self.name.."_active",
		param2=minetest.get_node(pos).param2
	})
	self:afterActivation(pos)
	minetest.get_node_timer(pos):start(industrialtest.config.updateDelay)
end

function industrialtest.ActivatedMachine.deactivate(self,pos)
	minetest.swap_node(pos,{
		name=self.name,
		param2=minetest.get_node(pos).param2
	})
	self:afterDeactivation(pos)
	minetest.get_node_timer(pos):start(industrialtest.config.updateDelay)
end

function industrialtest.ActivatedMachine.shouldActivate(self,pos)
	return false
end

function industrialtest.ActivatedMachine.shouldDeactivate(self,pos)
	return false
end

function industrialtest.ActivatedMachine.afterActivation(self,pos)
end

function industrialtest.ActivatedMachine.afterDeactivation(self,pos)
end

function industrialtest.ActivatedMachine.activeOnTimer(self,pos,elapsed)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	local shouldUpdateFormspec=false

	if self:shouldDeactivate(pos) then
		self:deactivate(pos)
		return false
	end

	if self.activeUpdate then
		shouldUpdateFormspec=self:activeUpdate(pos,elapsed,meta,inv)
	end

	if shouldUpdateFormspec then
		self:updateFormspec(pos)
	end

	return true
end
