-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.CableFormer=table.copy(industrialtest.SimpleElectricItemProcessor)
industrialtest.internal.unpackTableInto(industrialtest.CableFormer,{
	name="industrialtest:cable_former",
	description=S("Cable Former"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_cable_former_front.png"
	},
	requiresWrench=true,
	active={
		tiles={
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png^industrialtest_cable_former_front_active.png"
		}
	},
	capacity=1400,
	flow=industrialtest.api.lvPowerFlow,
	opPower=80,
	efficiency=1
})

function industrialtest.CableFormer.getCraftResult(self,itemstack)
	local output=industrialtest.api.getCableFormerRecipeResult(itemstack:get_name())
	if not output then
		return {
			item=ItemStack(),
			time=0,
			src=itemstack
		}
	end
	local srcAfter=ItemStack(itemstack:get_name())
	srcAfter:set_count(itemstack:get_count()-1)
	return {
		item=ItemStack(output.output),
		time=output.time,
		src=srcAfter
	}
end

industrialtest.CableFormer:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:cable_former",
	recipe={
		{"","industrialtest:electronic_circuit",""},
		{industrialtest.elementKeys.stoneSlab,industrialtest.elementKeys.stoneSlab,industrialtest.elementKeys.stoneSlab},
		{"","industrialtest:machine_block",""}
	}
})
