-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.ElectricFurnace=table.copy(industrialtest.SimpleElectricItemProcessor)
industrialtest.internal.unpackTableInto(industrialtest.ElectricFurnace,{
	name="industrialtest:electric_furnace",
	description=S("Electric Furnace"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_electric_furnace_front.png"
	},
	active={
		tiles={
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png^industrialtest_electric_furnace_front_active.png"
		}
	},
	capacity=416,
	flow=industrialtest.api.lvPowerFlow,
	opPower=60,
	efficiency=0.5
})

function industrialtest.ElectricFurnace.getCraftResult(self,itemstack)
	local output,after=minetest.get_craft_result({
		method="cooking",
		width=1,
		items={itemstack}
	})
	return {
		item=output.item,
		time=output.time,
		src=after.items[1]
	}
end

industrialtest.ElectricFurnace:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_furnace",
	recipe={
		{"","industrialtest:electronic_circuit",""},
		{industrialtest.elementKeys.powerCarrier,"industrialtest:iron_furnace",industrialtest.elementKeys.powerCarrier}
	}
})
