-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.SolarPanelBase=table.copy(industrialtest.ElectricMachine)
industrialtest.internal.unpackTableInto(industrialtest.SolarPanelBase,{
	sounds="metal",
	requiresWrench=true,
	storageLists={
		"charged"
	},
	powerLists={
		{
			list="charged",
			direction="o"
		}
	},
	hasPowerOutput=true,
	ioConfig="oooooo",
	multiplier=1
})

local solarPanels={}

function industrialtest.SolarPanelBase.onConstruct(self,pos)
	local meta=minetest.get_meta(pos)
	local inv=meta:get_inventory()
	inv:set_size("charged",1)
	meta:set_float("prevAmount",0)
	industrialtest.ElectricMachine.onConstruct(self,pos)
end

function industrialtest.SolarPanelBase.getFormspec(self,pos)
	local parentFormspec=industrialtest.ElectricMachine.getFormspec(self,pos)
	local amount=minetest.get_natural_light(vector.offset(pos,0,1,0))/15.0
	local charging=amount>0.5
	local formspec={
		"list[context;charged;4.7,1.8;1,1]",
		industrialtest.internal.getItemSlotBg(4.7,1.8,1,1),
		(charging and "image[4.7,2.8;1,1;industrialtest_gui_sun_fg.png]"
		 or "image[4.7,2.8;1,1;industrialtest_gui_sun_bg.png]"),
		"listring[context;charged]"
	}
	return parentFormspec..table.concat(formspec,"")
end

function industrialtest.SolarPanelBase.register(self)
	industrialtest.ElectricMachine.register(self)
	table.insert(solarPanels,self.name)
end

function industrialtest.SolarPanelBase.action(self,pos)
	local meta=minetest.get_meta(pos)
	local amount=minetest.get_natural_light(vector.offset(pos,0,1,0))/15.0
	local charging=amount>0.5
	if charging then
		if industrialtest.api.addPower(meta,math.ceil(amount*self.flow*self.multiplier))>0 then
			self:updateFormspec(pos)
		end
		self:trigger(pos)
	end
	if amount~=meta:get_float("prevAmount") then
		self:updateFormspec(pos)
		meta:set_float("prevAmount",amount)
	end
end

industrialtest.SolarPanel=table.copy(industrialtest.SolarPanelBase)
industrialtest.internal.unpackTableInto(industrialtest.SolarPanel,{
	name="industrialtest:solar_panel",
	description=S("Solar Panel"),
	tiles={
		"industrialtest_machine_block.png^industrialtest_solar_panel_top.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png"
	},
	capacity=industrialtest.api.lvPowerFlow*2,
	flow=industrialtest.api.lvPowerFlow
})

industrialtest.SolarPanel:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:solar_panel",
	recipe={
		{"industrialtest:coal_dust",industrialtest.elementKeys.glass,"industrialtest:coal_dust"},
		{industrialtest.elementKeys.glass,"industrialtest:coal_dust",industrialtest.elementKeys.glass},
		{"industrialtest:insulated_copper_cable","industrialtest:generator","industrialtest:insulated_copper_cable"}
	}
})

industrialtest.LVSolarArray=table.copy(industrialtest.SolarPanelBase)
industrialtest.internal.unpackTableInto(industrialtest.LVSolarArray,{
	name="industrialtest:lv_solar_array",
	description=S("LV Solar Array"),
	tiles={
		"industrialtest_machine_block.png^industrialtest_lv_solar_array_top.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png"
	},
	capacity=industrialtest.api.lvPowerFlow*4,
	flow=industrialtest.api.lvPowerFlow,
	multiplier=1.5
})

industrialtest.LVSolarArray:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:lv_solar_array",
	recipe={
		{"industrialtest:solar_panel","industrialtest:solar_panel","industrialtest:solar_panel"},
		{"industrialtest:solar_panel","industrialtest:lv_transformer","industrialtest:solar_panel"},
		{"industrialtest:solar_panel","industrialtest:solar_panel","industrialtest:solar_panel"}
	}
})

industrialtest.MVSolarArray=table.copy(industrialtest.SolarPanelBase)
industrialtest.internal.unpackTableInto(industrialtest.MVSolarArray,{
	name="industrialtest:mv_solar_array",
	description=S("MV Solar Array"),
	tiles={
		"industrialtest_machine_block.png^industrialtest_mv_solar_array_top.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png"
	},
	capacity=industrialtest.api.mvPowerFlow*2,
	flow=industrialtest.api.mvPowerFlow
})

industrialtest.MVSolarArray:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:mv_solar_array",
	recipe={
		{"industrialtest:lv_solar_array","industrialtest:lv_solar_array","industrialtest:lv_solar_array"},
		{"industrialtest:lv_solar_array","industrialtest:mv_transformer","industrialtest:lv_solar_array"},
		{"industrialtest:lv_solar_array","industrialtest:lv_solar_array","industrialtest:lv_solar_array"}
	}
})


industrialtest.HVSolarArray=table.copy(industrialtest.SolarPanelBase)
industrialtest.internal.unpackTableInto(industrialtest.HVSolarArray,{
	name="industrialtest:hv_solar_array",
	description=S("HV Solar Array"),
	tiles={
		"industrialtest_machine_block.png^industrialtest_hv_solar_array_top.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png"
	},
	capacity=industrialtest.api.hvPowerFlow*2,
	flow=industrialtest.api.hvPowerFlow
})

industrialtest.HVSolarArray:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:hv_solar_array",
	recipe={
		{"industrialtest:mv_solar_array","industrialtest:mv_solar_array","industrialtest:mv_solar_array"},
		{"industrialtest:mv_solar_array","industrialtest:hv_transformer","industrialtest:mv_solar_array"},
		{"industrialtest:mv_solar_array","industrialtest:mv_solar_array","industrialtest:mv_solar_array"}
	}
})

minetest.register_abm({
	name="Solar panel updating",
	nodenames=solarPanels,
	interval=industrialtest.config.updateDelay,
	chance=1,
	action=function(pos,node)
		local def=minetest.registered_nodes[node.name]
		def._industrialtest_self:action(pos)
	end
})
