-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.ElectricArmor={
	prepare=industrialtest.ElectricItem.prepare
}

function industrialtest.ElectricArmor.createDefinitionTableForElement(self,element)
	local def={
		description=element.description,
		inventory_image=element.inventoryImage,
		groups={
			_industrialtest_electricArmor=1,
			["armor_"..element.element]=1
		},
		_industrialtest_self=self
	}

	if industrialtest.mclAvailable then
		def.groups.armor=1
		def.groups.non_combat_armor=1
		def.sounds={
			_mcl_armor_equip="mcl_armor_equip_iron",
			_mcl_armor_unequip="mcl_armor_unequip_iron"
		}
		def.on_place=mcl_armor.armor_on_use
		def.on_secondary_use=mcl_armor.armor_on_use
		def._mcl_armor_element=element.element
		if type(element.texture)=="string" then
			def._mcl_armor_texture=element.texture
		else
			def._mcl_armor_texture=element.texture[2] or element.texture[1]
		end
	end

	return def
end

function industrialtest.ElectricArmor.register(self)
	for _,element in ipairs(self.elements) do
		local def=self:createDefinitionTableForElement(element)
		local name=self.name.."_"..element.name
		if industrialtest.mtgAvailable then
			armor:register_armor(name,def)
		elseif industrialtest.mclAvailable then
			minetest.register_tool(name,def)
		end
	end
end

function industrialtest.ElectricArmor.tryReduceDamage(self,itemstack,hpChange)
	local meta=itemstack:get_meta()
	local targetReducedDamage=math.floor(math.abs(hpChange)*self:getReducedDamageForItem(itemstack))
	local powerPerDamage=self:getPowerPerDamageForItem(itemstack)
	local requiredPower=targetReducedDamage*powerPerDamage
	local availablePower=math.min(meta:get_int("industrialtest.powerAmount"),requiredPower)
	return math.floor(availablePower/powerPerDamage)
end

function industrialtest.ElectricArmor.getReducedDamageForItem(self,itemstack)
	-- dummy function
	return 0
end

function industrialtest.ElectricArmor.getPowerPerDamageForItem(self,itemstack)
	-- dummy function
	return 0
end

minetest.register_on_player_hpchange(function(player,hpChange)
	if hpChange>0 or not player:is_player() then
		return hpChange
	end

	local inv
	if industrialtest.mtgAvailable then
		_,inv=armor:get_valid_player(player,"")
		if not inv then
			return hpChange
		end
	elseif industrialtest.mclAvailable then
		inv=player:get_inventory()
	end

	local armorList=inv:get_list("armor")
	assert(armorList)
	local result=hpChange
	for i=1,#armorList do
		local itemstack=armorList[i]
		local def=itemstack:get_definition()
		if def.groups and def.groups._industrialtest_electricArmor and def._industrialtest_self then
			local reducedDamage=def._industrialtest_self:tryReduceDamage(itemstack,hpChange)
			if reducedDamage>0 then
				result=result+reducedDamage
				industrialtest.api.addPowerToItem(itemstack,-reducedDamage*def._industrialtest_self:getPowerPerDamageForItem(itemstack))
				inv:set_stack("armor",i,itemstack)
			end
		end
	end

	return result
end,true)
