-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.ElectricDrillBase=table.copy(industrialtest.ActivatedElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricDrillBase,{
	digs={
		"cracky",
		"crumbly"
	}
})

function industrialtest.ElectricDrillBase.createDefinitionTable(self)
	local def=industrialtest.ActivatedElectricTool.createDefinitionTable(self)
	def.groups._industrialtest_miningDrill=1
	return def
end

function industrialtest.ElectricDrillBase.getOpPower(self,itemstack)
	return 50
end

industrialtest.ElectricDrill=table.copy(industrialtest.ElectricDrillBase)
industrialtest.internal.unpackTableInto(industrialtest.ElectricDrill,{
	name="industrialtest:electric_drill",
	description=S("Electric Drill"),
	inventoryImage="industrialtest_electric_drill.png",
	capacity=30000,
	flow=industrialtest.api.lvPowerFlow,
	digLevel=1,
	digSpeedClass=4,
	active={
		times={[1]=1.7,[2]=1.2,[3]=1.0,[4]=0.7},
		digSpeed=4
	}
})

industrialtest.ElectricDrill:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_drill",
	recipe={
		{"","industrialtest:refined_iron_ingot",""},
		{"industrialtest:refined_iron_ingot","industrialtest:electronic_circuit","industrialtest:refined_iron_ingot"},
		{"industrialtest:refined_iron_ingot","industrialtest:re_battery","industrialtest:refined_iron_ingot"}
	}
})

industrialtest.AdvancedElectricDrill=table.copy(industrialtest.ElectricDrillBase)
industrialtest.internal.unpackTableInto(industrialtest.AdvancedElectricDrill,{
	name="industrialtest:advanced_electric_drill",
	description=S("Advanced Electric Drill"),
	inventoryImage="industrialtest_advanced_electric_drill.png",
	capacity=30000,
	flow=industrialtest.api.lvPowerFlow,
	digLevel=0,
	digSpeedClass=5,
	active={
		times={[1]=1.0,[2]=0.7,[3]=0.3,[4]=0.1},
		digSpeed=7
	}
})

industrialtest.AdvancedElectricDrill:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:advanced_electric_drill",
	recipe={
		{"",industrialtest.elementKeys.diamond,""},
		{industrialtest.elementKeys.diamond,"industrialtest:electric_drill",industrialtest.elementKeys.diamond}
	}
})
