-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- This entire code is super hacky, I'm aware.

local S=minetest.get_translator("industrialtest")
industrialtest.ElectricSaberBase=table.copy(industrialtest.ActivatedElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricSaberBase,{
	fullPunchInterval=0.5,
	digs={"snappy"},
	hits={"fleshy"},
	capacity=100000,
	flow=industrialtest.api.hvPowerFlow
})

function industrialtest.ElectricSaberBase.createActiveDefinitionTable(self)
	self.define.onUse=false
	return industrialtest.ActivatedElectricTool.createActiveDefinitionTable(self)
end

function industrialtest.ElectricSaberBase.hitUse(self,itemstack,user,pointed)
	if self:canActivate(itemstack) and pointed.type=="object" then
		-- pointed is a ObjectRef
		industrialtest.api.addPowerToItem(itemstack,-self:getOpPower(itemstack))
		local toolCapabilities={damage_groups={}}
		for _,hitType in ipairs(self.hits) do
			toolCapabilities.damage_groups[hitType]=self.active.damage
		end
		pointed.ref:punch(user,nil,toolCapabilities)
		return true
	end
	return false
end

function industrialtest.ElectricSaberBase.afterUse(self,itemstack,user,node,digparams)
	industrialtest.ActivatedElectricTool.afterUse(self,itemstack,user,node,digparams)
	itemstack:set_name(self.name)
	return true
end

function industrialtest.ElectricSaberBase.getOpPower(self,itemstack)
	return 500
end

industrialtest.ElectricSaber=table.copy(industrialtest.ElectricSaberBase)
industrialtest.internal.unpackTableInto(industrialtest.ElectricSaber,{
	name="industrialtest:electric_saber",
	description=S("Electric Saber"),
	inventoryImage="industrialtest_electric_saber.png",
	digLevel=0,
	digSpeedClass=4,
	active={
		digSpeed=7,
		times={[1]=0.7,[2]=0.5,[3]=0.2,[4]=0.15},
		damage=3
	}
})

industrialtest.ElectricSaber:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_saber",
	recipe={
		{industrialtest.elementKeys.yellowDust,"industrialtest:advanced_alloy",""},
		{industrialtest.elementKeys.yellowDust,"industrialtest:advanced_alloy",""},
		{"industrialtest:carbon_plate","industrialtest:energy_crystal","industrialtest:carbon_plate"}
	}
})

industrialtest.AdvancedElectricSaber=table.copy(industrialtest.ElectricSaberBase)
industrialtest.internal.unpackTableInto(industrialtest.AdvancedElectricSaber,{
	name="industrialtest:advanced_electric_saber",
	description=S("Advanced Electric Saber"),
	inventoryImage="industrialtest_advanced_electric_saber.png",
	digLevel=0,
	digSpeedClass=5,
	active={
		digSpeed=8,
		times={[1]=0.5,[2]=0.2,[3]=0.15,[4]=0.1},
		damage=5
	}
})

industrialtest.AdvancedElectricSaber:register()

minetest.register_craft({
	type="shapeless",
	output="industrialtest:advanced_electric_saber",
	recipe={
		"industrialtest:electric_saber",
		industrialtest.elementKeys.diamond,
		industrialtest.elementKeys.diamond
	}
})
