-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")

industrialtest.FuelCan=table.copy(industrialtest.FluidContainerItem)
industrialtest.internal.unpackTableInto(industrialtest.FuelCan,{
	name="industrialtest:fuel_can",
	description=S("Fuel Can"),
	inventoryImage="industrialtest_fuel_can.png",
	capacity=10000
})

function industrialtest.FuelCan.createDefinitionTable(self)
	local def=industrialtest.FluidContainerItem.createDefinitionTable(self)
	def.groups._industrialtest_fueled=1
	def.groups._industrialtest_fuel=1
	return def
end

industrialtest.FuelCan:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:fuel_can",
	recipe={
		{"","industrialtest:tin_plate","industrialtest:tin_plate"},
		{"industrialtest:tin_plate","","industrialtest:tin_plate"},
		{"industrialtest:tin_plate","industrialtest:tin_plate","industrialtest:tin_plate"}
	}
})

