-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.GearTool=table.copy(industrialtest.Item)

function industrialtest.GearTool.createDefinitionTable(self)
	local def=industrialtest.Item.createDefinitionTable(self)

	def.groups._industrialtest_gearTool=1
	def.groups["armor_"..self.part]=1
	if industrialtest.mtgAvailable then
		def.groups.armor_heal=1
	elseif industrialtest.mclAvailable then
		def.groups.armor=1
		def.groups.non_combat_armor=1
		def.sounds={
			_mcl_armor_equip="mcl_armor_equip_iron",
			_mcl_armor_unequip="mcl_armor_unequip_iron"
		}
		def.on_place=mcl_armor.equip_on_use
		def.on_secondary_use=mcl_armor.equip_on_use
		def._mcl_armor_element=self.part
		def._mcl_armor_texture=self.modelImage
	end

	return def
end

function industrialtest.GearTool.register(self)
	local def=self:createDefinitionTable()
	if industrialtest.mtgAvailable then
		armor:register_armor(self.name,def)
	elseif industrialtest.mclAvailable then
		minetest.register_tool(self.name,def)
	end
end

minetest.register_globalstep(function(dtime)
	local players=minetest.get_connected_players()
	for _,player in ipairs(players) do
		local inv
		if industrialtest.mtgAvailable then
			_,inv=armor:get_valid_player(player,"")
		elseif industrialtest.mclAvailable then
			inv=player:get_inventory()
		end
		if inv then
			local armorList=inv:get_list("armor")
			assert(armorList)
			for i,itemstack in ipairs(armorList) do
				local def=itemstack:get_definition()
				if def and def.groups._industrialtest_gearTool and def._industrialtest_self and def._industrialtest_self.update and
					def._industrialtest_self:update(player,inv,itemstack,dtime) then
					inv:set_stack("armor",i,itemstack)
				end
			end
		end
	end
end)
