-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.Item={}

function industrialtest.Item.createDefinitionTable(self)
	local def={
		description=self.description,
		inventory_image=self.inventoryImage,
		groups={},
		_industrialtest_self=self
	}

	if industrialtest.mtgAvailable then
		def.groups.flammable=self.flammable
	end

	return def
end

function industrialtest.Item.register(self)
	local def=self:createDefinitionTable()
	minetest.register_tool(self.name,def)
end

-- Item callbacks
minetest.register_on_player_inventory_action(function(player,action,inventory,info)
	if action=="put" then
		local def=info.stack:get_definition()
		if def and def._industrialtest_self and def._industrialtest_self.prepare then
			def._industrialtest_self:prepare(info.stack)
			inventory:set_stack(info.listname,info.index,info.stack)
		end
	end
end)
minetest.register_on_craft(function(itemstack)
	local def=itemstack:get_definition()
	if def and def._industrialtest_self and def._industrialtest_self.prepare then
		def._industrialtest_self:prepare(itemstack)
	end
end)
