-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- \brief Takes rotated node and side and outputs normalized side that can be used for ioConfig lookups
-- \param pos Vector with node position
-- \param side Node side. See industrialtest.api.addPowerStorage for possible values
-- \returns Normalized side or in case of failure side argument back
function industrialtest.api.normalizeSide(pos,side)
	local node=minetest.get_node(pos)
	-- FIXME: improve code quality there
	local translation={
		[0]={
			1,2,3,4,5,6
		},
		[1]={
			5,6,3,4,1,2
		},
		[2]={
			2,1,3,4,6,5
		},
		[3]={
			6,5,3,4,2,1
		}
	}
	if node.param2>3 then
		return side
	end
	return translation[node.param2][side]
end

-- \brief Returns opposite side of provided one
-- \param side Side number. See industrialtest.api.addPowerStorage for order
-- \returns Opposite side
function industrialtest.api.getOppositeSide(side)
	return (side%2==0 and side-1 or side+1)
end
