-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.Transformer=table.copy(industrialtest.ElectricMachine)
industrialtest.internal.unpackTableInto(industrialtest.Transformer,{
	withoutFormspec=true,
	facedir=true,
	storageLists={},
	powerLists={},
	hasPowerInput=true,
	hasPowerOutput=true
})

function industrialtest.Transformer.register(self)
	self.ioConfig={
		{
			mode="a",
			flow=self.lowerFlow
		},
		{
			mode="a",
			flow=self.lowerFlow
		},
		{
			mode="a",
			flow=self.lowerFlow
		},
		{
			mode="a",
			flow=self.lowerFlow
		},
		{
			mode="a",
			flow=self.flow
		},
		{
			mode="a",
			flow=self.lowerFlow
		}
	}
	industrialtest.ElectricMachine.register(self)
end

function industrialtest.Transformer.onPowerFlow(self,pos)
	self:trigger(pos)
end

industrialtest.LVTransformer=table.copy(industrialtest.Transformer)
industrialtest.internal.unpackTableInto(industrialtest.LVTransformer,{
	name="industrialtest:lv_transformer",
	description=S("LV Transformer"),
	sounds="wood",
	tiles={
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_side.png",
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_side.png",
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_side.png",
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_side.png",
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_side.png",
		"industrialtest_wood_machine_block.png^industrialtest_lv_transformer_front.png"
	},
	capacity=industrialtest.api.mvPowerFlow,
	flow=industrialtest.api.mvPowerFlow,
	lowerFlow=industrialtest.api.lvPowerFlow
})

industrialtest.LVTransformer:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:lv_transformer",
	recipe={
		{"group:wood","industrialtest:insulated_tin_cable","group:wood"},
		{industrialtest.elementKeys.copperIngot,industrialtest.elementKeys.copperIngot,industrialtest.elementKeys.copperIngot},
		{"group:wood","industrialtest:insulated_copper_cable","group:wood"}
	}
})

industrialtest.MVTransformer=table.copy(industrialtest.Transformer)
industrialtest.internal.unpackTableInto(industrialtest.MVTransformer,{
	name="industrialtest:mv_transformer",
	description=S("MV Transformer"),
	sounds="metal",
	requiresWrench=true,
	tiles={
		"industrialtest_machine_block.png^industrialtest_mv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_mv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_mv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_mv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_mv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_mv_transformer_front.png"
	},
	capacity=industrialtest.api.hvPowerFlow,
	flow=industrialtest.api.hvPowerFlow,
	lowerFlow=industrialtest.api.mvPowerFlow
})

industrialtest.MVTransformer:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:mv_transformer",
	recipe={
		{"industrialtest:insulated_copper_cable"},
		{"industrialtest:machine_block"},
		{"industrialtest:insulated_gold_cable"}
	}
})

industrialtest.HVTransformer=table.copy(industrialtest.Transformer)
industrialtest.internal.unpackTableInto(industrialtest.HVTransformer,{
	name="industrialtest:hv_transformer",
	description=S("HV Transformer"),
	sounds="metal",
	requiresWrench=true,
	tiles={
		"industrialtest_machine_block.png^industrialtest_hv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_hv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_hv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_hv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_hv_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_hv_transformer_front.png"
	},
	capacity=industrialtest.api.evPowerFlow,
	flow=industrialtest.api.evPowerFlow,
	lowerFlow=industrialtest.api.hvPowerFlow
})

industrialtest.HVTransformer:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:hv_transformer",
	recipe={
		{"","industrialtest:insulated_iron_cable",""},
		{"industrialtest:electronic_circuit","industrialtest:mv_transformer","industrialtest:energy_crystal"},
		{"","industrialtest:insulated_iron_cable",""}
	}
})

industrialtest.EVTransformer=table.copy(industrialtest.Transformer)
industrialtest.internal.unpackTableInto(industrialtest.EVTransformer,{
	name="industrialtest:ev_transformer",
	description=S("EV Transformer"),
	sounds="metal",
	requiresWrench=true,
	tiles={
		"industrialtest_machine_block.png^industrialtest_ev_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_ev_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_ev_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_ev_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_ev_transformer_side.png",
		"industrialtest_machine_block.png^industrialtest_ev_transformer_front.png"
	},
	capacity=industrialtest.api.ivPowerFlow,
	flow=industrialtest.api.ivPowerFlow,
	lowerFlow=industrialtest.api.evPowerFlow
})

industrialtest.EVTransformer:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:ev_transformer",
	recipe={
		{"","industrialtest:insulated_iron_cable",""},
		{"industrialtest:advanced_electronic_circuit","industrialtest:hv_transformer","industrialtest:lapotron_crystal"},
		{"","industrialtest:insulated_iron_cable",""}
	}
})
