-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.ElectricChainsawBase=table.copy(industrialtest.ActivatedElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricChainsawBase,{
	digs={"choppy"}
})

function industrialtest.ElectricChainsawBase.use(self,itemstack,user,pointed)
	if not industrialtest.mclAvailable then
		return false
	end
	local meta=itemstack:get_meta()
	local itemstackCopy=itemstack
	return itemstack:get_wear()~=industrialtest.internal.mclMakeStrippedTrunk(itemstackCopy,user,pointed,true):get_wear()
end

function industrialtest.ElectricChainsawBase.getOpPower(self,itemstack)
	return 50
end

industrialtest.ElectricChainsaw=table.copy(industrialtest.ElectricChainsawBase)
industrialtest.internal.unpackTableInto(industrialtest.ElectricChainsaw,{
	name="industrialtest:electric_chainsaw",
	description=S("Electric Chainsaw"),
	inventoryImage="industrialtest_electric_chainsaw.png",
	capacity=10000,
	flow=industrialtest.api.lvPowerFlow,
	digLevel=0,
	digSpeedClass=4,
	digSpeed=1,
	active={
		times={[1]=1.7,[2]=1.2,[3]=1.0,[4]=0.7},
		digSpeed=7
	}
})

industrialtest.ElectricChainsaw:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_chainsaw",
	recipe={
		{"","industrialtest:refined_iron_ingot","industrialtest:refined_iron_ingot"},
		{"industrialtest:refined_iron_ingot","industrialtest:electronic_circuit","industrialtest:refined_iron_ingot"},
		{"industrialtest:re_battery","industrialtest:refined_iron_ingot",""}
	}
})

industrialtest.AdvancedElectricChainsaw=table.copy(industrialtest.ElectricChainsawBase)
industrialtest.internal.unpackTableInto(industrialtest.AdvancedElectricChainsaw,{
	name="industrialtest:advanced_electric_chainsaw",
	description=S("Advanced Electric Chainsaw"),
	inventoryImage="industrialtest_advanced_electric_chainsaw.png",
	capacity=10000,
	flow=industrialtest.api.lvPowerFlow,
	digLevel=0,
	digSpeedClass=5,
	digSpeed=1,
	active={
		times={[1]=1.0,[2]=0.7,[3]=0.5,[4]=0.2},
		digSpeed=8
	}
})

industrialtest.AdvancedElectricChainsaw:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:advanced_electric_chainsaw",
	recipe={
		{"",industrialtest.elementKeys.diamond,""},
		{industrialtest.elementKeys.diamond,"industrialtest:electric_chainsaw",industrialtest.elementKeys.diamond}
	}
})
