-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.ElectricHoeBase=table.copy(industrialtest.ActivatedElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricHoeBase,{
	digs={"hoey"},
	capacity=10000,
	flow=industrialtest.api.lvPowerFlow
})

function industrialtest.ElectricHoeBase.register(self)
	if industrialtest.mtgAvailable then
		self.define.onUse=true
	elseif industrialtest.mclAvailable then
		self.define.onPlace=true
	end

	industrialtest.ActivatedElectricTool.register(self)
end

function industrialtest.ElectricHoeBase.hitUse(self,itemstack,user,pointed)
	-- Taken and adapted from farming mod from Minetest Game
	local pt = pointed
	-- check if pointing at a node
	if not pt then
		return false
	end
	if pt.type ~= "node" then
		return false
	end

	local under = minetest.get_node(pt.under)
	local p = {x=pt.under.x, y=pt.under.y+1, z=pt.under.z}
	local above = minetest.get_node(p)

	-- return if any of the nodes is not registered
	if not minetest.registered_nodes[under.name] then
		return false
	end
	if not minetest.registered_nodes[above.name] then
		return false
	end

	-- check if the node above the pointed thing is air
	if above.name ~= "air" then
		return false
	end

	-- check if pointing at soil
	if minetest.get_item_group(under.name, "soil") ~= 1 then
		return false
	end

	-- check if (wet) soil defined
	local regN = minetest.registered_nodes
	if regN[under.name].soil == nil or regN[under.name].soil.wet == nil or regN[under.name].soil.dry == nil then
		return false
	end

	local player_name = user and user:get_player_name() or ""

	if minetest.is_protected(pt.under, player_name) then
		minetest.record_protection_violation(pt.under, player_name)
		return false
	end
	if minetest.is_protected(pt.above, player_name) then
		minetest.record_protection_violation(pt.above, player_name)
		return false
	end

	-- turn the node into soil and play sound
	minetest.set_node(pt.under, {name = regN[under.name].soil.dry})
	minetest.sound_play("default_dig_crumbly", {
		pos = pt.under,
		gain = 0.3,
	}, true)

	return true
end

function industrialtest.ElectricHoeBase.use(self,itemstack,user,pointed)
	local node=minetest.get_node(pointed.under)
	if user and not user:get_player_control().sneak then
		if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
			minetest.registered_nodes[node.name].on_rightclick(pointed.under,node,user,itemstack)
			return false
		end
	end
	if minetest.is_protected(pointed.under, user:get_player_name()) then
		minetest.record_protection_violation(pointed.under,user:get_player_name())
		return false
	end

	-- Taken and adapted from https://git.minetest.land/MineClone2/MineClone2/src/branch/master/mods/ITEMS/mcl_farming/hoes.lua#L3
	local name = node.name
	local above = minetest.get_node({x=pointed.under.x, y=pointed.under.y+1, z=pointed.under.z})
	if minetest.get_item_group(name, "cultivatable") == 2 then
		if above.name == "air" then
			node.name = "mcl_farming:soil"
			minetest.set_node(pointed.under, node)
			minetest.sound_play("default_dig_crumbly", { pos = pointed.under, gain = 0.5 }, true)
			return true
		end
	elseif minetest.get_item_group(name, "cultivatable") == 1 then
		if above.name == "air" then
			node.name = "mcl_core:dirt"
			minetest.set_node(pointed.under, node)
			minetest.sound_play("default_dig_crumbly", { pos = pointed.under, gain = 0.6 }, true)
			return true
		end
	end
	return false
end

function industrialtest.ElectricHoeBase.getOpPower(self,itemstack)
	return 50
end

industrialtest.ElectricHoe=table.copy(industrialtest.ElectricHoeBase)
industrialtest.internal.unpackTableInto(industrialtest.ElectricHoe,{
	name="industrialtest:electric_hoe",
	description=S("Electric Hoe"),
	inventoryImage="industrialtest_electric_hoe.png",
	digLevel=0,
	digSpeedClass=4,
	active={
		digSpeed=3
	}
})

industrialtest.ElectricHoe:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_hoe",
	recipe={
		{"industrialtest:refined_iron_ingot","industrialtest:refined_iron_ingot"},
		{"","industrialtest:electronic_circuit"},
		{"","industrialtest:re_battery"}
	}
})
minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_hoe",
	recipe={
		{"industrialtest:refined_iron_ingot","industrialtest:refined_iron_ingot"},
		{"industrialtest:electronic_circuit",""},
		{"industrialtest:re_battery",""}
	}
})

if industrialtest.mclAvailable then
	industrialtest.AdvancedElectricHoe=table.copy(industrialtest.ElectricHoeBase)
	industrialtest.internal.unpackTableInto(industrialtest.AdvancedElectricHoe,{
		name="industrialtest:advanced_electric_hoe",
		description=S("Advanced Electric Hoe"),
		inventoryImage="industrialtest_advanced_electric_hoe.png",
		digLevel=0,
		digSpeedClass=5,
		active={
			digSpeed=7
		}
	})

	industrialtest.AdvancedElectricHoe:register()

	minetest.register_craft({
		type="shapeless",
		output="industrialtest:advanced_electric_hoe",
		recipe={
			"industrialtest:electric_hoe",
			industrialtest.elementKeys.diamond,
			industrialtest.elementKeys.diamond
		}
	})
end
