-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.ElectricTool=table.copy(industrialtest.Tool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricTool,{
	prepare=industrialtest.ElectricItem.prepare
})

function industrialtest.ElectricTool.createDefinitionTable(self)
	local def=industrialtest.Tool.createDefinitionTable(self)
	def.after_use=function()
		-- Hack to make sure that chainsaw won't be destroyed when has 0 EU
		return nil
	end
	return def
end

function industrialtest.ElectricTool.onPlace(self,itemstack,user,pointed)
	self:prepare(itemstack)

	local meta=itemstack:get_meta()
	local opPower=self:getOpPower(itemstack)
	if meta:get_int("industrialtest.powerAmount")<opPower then
		return false
	end

	if self:use(itemstack,user,pointed) then
		industrialtest.api.addPowerToItem(itemstack,-opPower)
	end
	return true
end

function industrialtest.ElectricTool.onUse(self,itemstack,user,pointed)
	self:prepare(itemstack)

	if user:is_player() then
		local controls=user:get_player_control()
		if controls.sneak and self:changeMode(itemstack) then
			return true
		end
	end

	local meta=itemstack:get_meta()
	local opPower=self:getOpPower(itemstack)
	if meta:get_int("industrialtest.powerAmount")<opPower then
		return false
	end

	if self:hitUse(itemstack,user,pointed) then
		industrialtest.api.addPowerToItem(itemstack,-opPower)
	end
	return true
end

function industrialtest.ElectricTool.changeMode(self,itemstack)
	-- dummy function
	return false
end

function industrialtest.ElectricTool.getOpPower(self,itemstack)
	-- dummy function
	return 0
end
