-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.NanoSuit=table.copy(industrialtest.ElectricArmor)
industrialtest.internal.unpackTableInto(industrialtest.NanoSuit,{
	name="industrialtest:nano",
	elements={
		{
			name="helmet",
			description=S("Nano Helmet"),
			element="head",
			inventoryImage="industrialtest_nano_helmet_inv.png",
			texture="industrialtest_nano_helmet.png"
		},
		{
			name="bodyarmor",
			description=S("Nano Bodyarmor"),
			element="torso",
			inventoryImage="industrialtest_nano_bodyarmor_inv.png",
			texture="industrialtest_nano_bodyarmor.png"
		},
		{
			name="leggings",
			description=S("Nano Leggings"),
			element="legs",
			inventoryImage="industrialtest_nano_leggings_inv.png",
			texture="industrialtest_nano_leggings.png"
		},
		{
			name="boots",
			description=S("Nano Boots"),
			element="feet",
			inventoryImage="industrialtest_nano_boots_inv.png",
			texture={
				"industrialtest_nano_boots.png",
				"industrialtest_mcl_nano_boots.png"
			}
		}
	},
	capacity=1000000,
	flow=industrialtest.api.evPowerFlow
})

function industrialtest.NanoSuit.getReducedDamageForItem(self,itemstack)
	local def=itemstack:get_definition()
	if def.groups.armor_head then
		return 0.12
	elseif def.groups.armor_torso then
		return 0.32
	elseif def.groups.armor_legs then
		return 0.3
	elseif def.groups.armor_feet then
		return 0.24
	end
	return 0
end

function industrialtest.NanoSuit.getPowerPerDamageForItem(self,itemstack)
	return 5000
end

industrialtest.NanoSuit:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:nano_helmet",
	recipe={
		{"industrialtest:carbon_plate","industrialtest:energy_crystal","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate",industrialtest.elementKeys.glass,"industrialtest:carbon_plate"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:nano_bodyarmor",
	recipe={
		{"industrialtest:carbon_plate","","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate","industrialtest:energy_crystal","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate","industrialtest:carbon_plate","industrialtest:carbon_plate"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:nano_leggings",
	recipe={
		{"industrialtest:carbon_plate","industrialtest:energy_crystal","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate","","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate","","industrialtest:carbon_plate"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:nano_boots",
	recipe={
		{"industrialtest:carbon_plate","","industrialtest:carbon_plate"},
		{"industrialtest:carbon_plate","industrialtest:energy_crystal","industrialtest:carbon_plate"}
	}
})
