-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")

industrialtest.REBattery=table.copy(industrialtest.ElectricItem)
industrialtest.internal.unpackTableInto(industrialtest.REBattery,{
	name="industrialtest:re_battery",
	description=S("RE-Battery"),
	inventoryImage="industrialtest_re_battery.png",
	capacity=7000,
	flow=industrialtest.api.lvPowerFlow
})

industrialtest.REBattery:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:re_battery",
	recipe={
		{"","industrialtest:insulated_tin_cable",""},
		{industrialtest.elementKeys.tinIngot,industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.tinIngot},
		{industrialtest.elementKeys.tinIngot,industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.tinIngot}
	}
})

industrialtest.AdvancedREBattery=table.copy(industrialtest.ElectricItem)
industrialtest.internal.unpackTableInto(industrialtest.AdvancedREBattery,{
	name="industrialtest:advanced_re_battery",
	description=S("Advanced RE-Battery"),
	inventoryImage="industrialtest_advanced_re_battery.png",
	capacity=100000,
	flow=industrialtest.api.mvPowerFlow
})

industrialtest.AdvancedREBattery:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:advanced_re_battery",
	recipe={
		{"industrialtest:insulated_copper_cable",industrialtest.elementKeys.bronzeIngot,"industrialtest:insulated_copper_cable"},
		{industrialtest.elementKeys.bronzeIngot,"industrialtest:sulfur_dust",industrialtest.elementKeys.bronzeIngot},
		{industrialtest.elementKeys.bronzeIngot,"industrialtest:lead_dust",industrialtest.elementKeys.bronzeIngot}
	}
})

industrialtest.EnergyCrystal=table.copy(industrialtest.ElectricItem)
industrialtest.internal.unpackTableInto(industrialtest.EnergyCrystal,{
	name="industrialtest:energy_crystal",
	description=S("Energy Crystal"),
	inventoryImage="industrialtest_energy_crystal.png",
	capacity=1000000,
	flow=industrialtest.api.hvPowerFlow
})

industrialtest.EnergyCrystal:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:energy_crystal",
	recipe={
		{industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.powerCarrier},
		{industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.diamond,industrialtest.elementKeys.powerCarrier},
		{industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.powerCarrier,industrialtest.elementKeys.powerCarrier}
	}
})

industrialtest.LapotronCrystal=table.copy(industrialtest.ElectricItem)
industrialtest.internal.unpackTableInto(industrialtest.LapotronCrystal,{
	name="industrialtest:lapotron_crystal",
	description=S("Lapotron Crystal"),
	inventoryImage="industrialtest_lapotron_crystal.png",
	capacity=10000000,
	flow=industrialtest.api.evPowerFlow
})

industrialtest.LapotronCrystal:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:lapotron_crystal",
	recipe={
		{industrialtest.elementKeys.blueDye,"industrialtest:electronic_circuit",industrialtest.elementKeys.blueDye},
		{industrialtest.elementKeys.blueDye,"industrialtest:energy_crystal",industrialtest.elementKeys.blueDye},
		{industrialtest.elementKeys.blueDye,"industrialtest:electronic_circuit",industrialtest.elementKeys.blueDye}
	}
})
