-- IndustrialTest
-- Copyright (C) 2025 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")

industrialtest.Scanner=table.copy(industrialtest.ElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.Scanner,{
	define={onUse=true}
})

function industrialtest.Scanner.createDefinitionTable(self)
	local def=industrialtest.ElectricTool.createDefinitionTable(self)
	def.groups._industrialtest_scanner=1
	return def
end

-- Used by Miner to provide Scanner functionality there
function industrialtest.Scanner.filter(self,pos)
	-- dummy function
	return {}
end

industrialtest.OreScanner=table.copy(industrialtest.Scanner)

function industrialtest.OreScanner.hitUse(self,itemstack,user,pointed)
	if not user:is_player() then
		return false
	end

	local positions=""
	local pos=user:get_pos()
	for x=pos.x-self.distance,pos.x+self.distance do
		for y=pos.y-self.distance,pos.y+self.distance do
			for z=pos.z-self.distance,pos.z+self.distance do
				local targetPos=vector.new(x,y,z)
				local node=minetest.get_node(targetPos)
				if self.isOre(node) then
					positions=positions..string.format("%d %d %d",x,y,z)
					positions=positions..","
				end
			end
		end
	end

	local formspec={
		"formspec_version[4]",
		"size[10.5,11]",
		"label[0.5,0.5;"..self.description.."]",
		"label[0.5,1.7;"..S("Found ores").."]",
		"textlist[0.5,1.9;9.5,8.6;pos;"..positions.."]"
	}
	local content=table.concat(formspec,"")
	minetest.show_formspec(user:get_player_name(),"industrialtest:scanner",content)

	return true
end

function industrialtest.OreScanner.filter(self,pos)
	local result={}
	for x=pos.x-self.minerDistance,pos.x+self.minerDistance do
		for z=pos.z-self.minerDistance,pos.z+self.minerDistance do
			local nodePos=vector.new(x,pos.y,z)
			local node=minetest.get_node(nodePos)
			-- This is very hacky, but currently there is no other way of determining if node is ore
			if (x~=pos.x or z~=pos.z) and self.isOre(node) then
				table.insert(result,nodePos)
			end
		end
	end
	return result
end

function industrialtest.OreScanner.isOre(node)
	return string.find(node.name,":stone_with_")
end

industrialtest.ODScanner=table.copy(industrialtest.OreScanner)
industrialtest.internal.unpackTableInto(industrialtest.ODScanner,{
	name="industrialtest:od_scanner",
	description=S("OD Scanner"),
	inventoryImage="industrialtest_od_scanner.png",
	capacity=100000,
	flow=industrialtest.api.lvPowerFlow,
	distance=7,
	minerDistance=3
})

function industrialtest.ODScanner.getOpPower(self,itemstack)
	return 700
end

industrialtest.ODScanner:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:od_scanner",
	recipe={
		{"",industrialtest.elementKeys.yellowDust,""},
		{"industrialtest:electronic_circuit","industrialtest:re_battery","industrialtest:electronic_circuit"},
		{"industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable","industrialtest:insulated_copper_cable"}
	}
})

industrialtest.OVScanner=table.copy(industrialtest.OreScanner)
industrialtest.internal.unpackTableInto(industrialtest.OVScanner,{
	name="industrialtest:ov_scanner",
	description=S("OV Scanner"),
	inventoryImage="industrialtest_ov_scanner.png",
	capacity=1000000,
	flow=industrialtest.api.mvPowerFlow,
	distance=11,
	minerDistance=5
})

function industrialtest.OVScanner.getOpPower(self,itemstack)
	return 7000
end

industrialtest.OVScanner:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:ov_scanner",
	recipe={
		{"",industrialtest.elementKeys.yellowDust,""},
		{industrialtest.elementKeys.yellowDust,"industrialtest:electronic_circuit",industrialtest.elementKeys.yellowDust},
		{"industrialtest:insulated_gold_cable","industrialtest:od_scanner","industrialtest:insulated_gold_cable"}
	}
})

minetest.register_craft({
	type="shaped",
	output="industrialtest:ov_scanner",
	recipe={
		{"",industrialtest.elementKeys.yellowDust,""},
		{industrialtest.elementKeys.yellowDust,"industrialtest:electronic_circuit",industrialtest.elementKeys.yellowDust},
		{"industrialtest:insulated_gold_cable","industrialtest:re_battery","industrialtest:insulated_gold_cable"}
	}
})
