-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License

local S=minetest.get_translator("industrialtest")

local function onWrenchUse(user,pointed)
	if pointed.type~="node" or not user or not user:is_player() then
		return false
	end
	local node=minetest.get_node_or_nil(pointed.under)
	if not node then
		return false
	end
	local def=minetest.registered_nodes[node.name]
	if not def or not def.groups or not def.groups._industrialtest_wrenchUnmountable or (def.can_dig and not def.can_dig(pointed.under)) then
		return false
	end
	local inv=user:get_inventory()
	if def.after_dig_node then
		def.after_dig_node(pointed.under,node,minetest.get_meta(pointed.under):to_table())
	end
	minetest.remove_node(pointed.under)
	local name=node.name
	if string.sub(name,-7)=="_active" then
		name=string.sub(name,1,-8)
	end
	inv:add_item("main",ItemStack(name))
	return true
end

industrialtest.Wrench=table.copy(industrialtest.Tool)
industrialtest.internal.unpackTableInto(industrialtest.Wrench,{
	name="industrialtest:wrench",
	define={onUse=true},
	description=S("Wrench"),
	inventoryImage="industrialtest_wrench.png",
	uses=200,
	repairMaterial=industrialtest.elementKeys.bronzeIngot
})

function industrialtest.Wrench.hitUse(self,itemstack,user,pointed)
	return onWrenchUse(user,pointed)
end

industrialtest.Wrench:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:wrench",
	recipe={
		{industrialtest.elementKeys.bronzeIngot,"",industrialtest.elementKeys.bronzeIngot},
		{industrialtest.elementKeys.bronzeIngot,industrialtest.elementKeys.bronzeIngot,industrialtest.elementKeys.bronzeIngot},
		{"",industrialtest.elementKeys.bronzeIngot,""}
	}
})

industrialtest.ElectricWrench=table.copy(industrialtest.ElectricTool)
industrialtest.internal.unpackTableInto(industrialtest.ElectricWrench,{
	name="industrialtest:electric_wrench",
	define={onUse=true},
	description=S("Electric Wrench"),
	inventoryImage="industrialtest_electric_wrench.png",
	capacity=10000,
	flow=industrialtest.api.lvPowerFlow
})

function industrialtest.ElectricWrench.getOpPower(self,itemstack)
	return 50
end

function industrialtest.ElectricWrench.hitUse(self,itemstack,user,pointed)
	return onWrenchUse(user,pointed)
end

industrialtest.ElectricWrench:register()

minetest.register_craft({
	type="shapeless",
	output="industrialtest:electric_wrench",
	recipe={
		"industrialtest:wrench",
		"industrialtest:electronic_circuit",
		"industrialtest:re_battery"
	}
})
