-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

industrialtest.api={
	maceratorRecipes={},
	compressorRecipes={},
	extractorRecipes={},
	cableFormerRecipes={},
	geothermalGeneratorFuels={},
	waterMillFuels={},
	rotaryMaceratorModifiers={},
	storageCells={},
	tags={}
}

industrialtest.api.lvPowerFlow=600
industrialtest.api.mvPowerFlow=2400
industrialtest.api.hvPowerFlow=10200
industrialtest.api.evPowerFlow=40800
industrialtest.api.ivPowerFlow=163800

function industrialtest.internal.clamp(num,min,max)
	return math.max(math.min(num,max),min)
end

function industrialtest.internal.unpackTableInto(first,second)
	for k,v in pairs(second) do
		first[k]=v
	end
end

-- \brief Returns machine speed in items per operation
-- \param meta MetaDataRef
-- \returns number
function industrialtest.api.getMachineSpeed(meta)
	return meta:contains("industrialtest.speed") and meta:get_int("industrialtest.speed") or 1
end
