-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.BatPackBase=table.copy(industrialtest.ElectricGearTool)
industrialtest.internal.unpackTableInto(industrialtest.BatPackBase,{
	part="torso"
})

local updateDelta=0
function industrialtest.BatPackBase.update(self,player,inv,itemstack,dtime)
	updateDelta=updateDelta+dtime
	if updateDelta<industrialtest.config.updateDelay then
		return false
	end
	updateDelta=0

	local wielded=player:get_wielded_item()
	local wieldedMeta=wielded:get_meta()
	if not industrialtest.api.hasPowerStorage(wieldedMeta) or wieldedMeta:get_int("industrialtest.powerFlow")>self.flow then
		return false
	end
	if industrialtest.api.transferPowerFromItem(itemstack,wieldedMeta,self.flow)>0 then
		industrialtest.api.updateItemPowerText(wielded)
		player:set_wielded_item(wielded)
		return true
	end
	return false
end

industrialtest.BatPack=table.copy(industrialtest.BatPackBase)
industrialtest.internal.unpackTableInto(industrialtest.BatPack,{
	name="industrialtest:batpack_v",
	description=S("BatPack"),
	inventoryImage="industrialtest_batpack_v_inv.png",
	modelImage="industrialtest_batpack_v.png",
	capacity=60000,
	flow=industrialtest.api.lvPowerFlow
})

industrialtest.BatPack:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:batpack_v",
	recipe={
		{"industrialtest:re_battery","industrialtest:electronic_circuit","industrialtest:re_battery"},
		{"industrialtest:re_battery",industrialtest.elementKeys.tinIngot,"industrialtest:re_battery"},
		{"industrialtest:re_battery","","industrialtest:re_battery"}
	}
})

industrialtest.LapPack=table.copy(industrialtest.BatPackBase)
industrialtest.internal.unpackTableInto(industrialtest.LapPack,{
	name="industrialtest:lappack_v",
	description=S("LapPack"),
	inventoryImage="industrialtest_lappack_v_inv.png",
	modelImage="industrialtest_lappack_v.png",
	capacity=60000,
	flow=industrialtest.api.lvPowerFlow
})

industrialtest.LapPack:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:lappack_v",
	recipe={
		{industrialtest.elementKeys.powerCarrier,"industrialtest:electronic_circuit",industrialtest.elementKeys.powerCarrier},
		{industrialtest.elementKeys.powerCarrier,"industrialtest:batpack_v",industrialtest.elementKeys.powerCarrier},
		{industrialtest.elementKeys.powerCarrier,"",industrialtest.elementKeys.powerCarrier}
	}
})
