-- IndustrialTest
-- Copyright (C) 2023 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.Compressor=table.copy(industrialtest.SimpleElectricItemProcessor)
industrialtest.internal.unpackTableInto(industrialtest.Compressor,{
	name="industrialtest:compressor",
	description=S("Compressor"),
	tiles={
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png",
		"industrialtest_machine_block.png^industrialtest_compressor_front.png"
	},
	requiresWrench=true,
	active={
		tiles={
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png",
			"industrialtest_machine_block.png^industrialtest_compressor_front_active.png"
		}
	},
	capacity=1400,
	flow=industrialtest.api.lvPowerFlow,
	opPower=120,
	efficiency=1
})

function industrialtest.Compressor.getCraftResult(self,itemstack)
	local output=industrialtest.api.getCompressorRecipeResult(itemstack:get_name())
	if not output or itemstack:get_count()<output.count then
		return {
			item=ItemStack(),
			time=0,
			src=itemstack
		}
	end
	local srcAfter=ItemStack(itemstack:get_name())
	srcAfter:set_count(itemstack:get_count()-output.count)
	return {
		item=ItemStack(output.output),
		time=output.time,
		src=srcAfter
	}
end

function industrialtest.Compressor.canPushFluid(self,pos,fluidType,fluidAmount)
	local meta=minetest.get_meta(pos)
	local compressedFluid=industrialtest.api.getCompressedFluid(fluidType)
	if not self.isRecipeOverride(meta) and compressedFluid and fluidAmount>=compressedFluid.requiredAmount then
		local inv=meta:get_inventory()
		local resultingStack=ItemStack(compressedFluid.result)
		if inv:room_for_item("dst",resultingStack) then
			return true
		end
	end
	return false
end

-- Called by Pump when Compressor is next to it while it tries to push fluid
function industrialtest.Compressor.onPumpFluidPush(self,pos,pumpPos,fluidType,fluidAmount)
	local compressedFluid=industrialtest.api.getCompressedFluid(fluidType)
	if compressedFluid then
		local meta=minetest.get_meta(pos)
		-- If recipe can be overriden keep information about this in meta so it's picked up by superclass
		meta:set_string("recipeOverride",compressedFluid.result)
		meta:set_int("recipeOverrideMaxTime",compressedFluid.time)
		fluidAmount=fluidAmount-compressedFluid.requiredAmount
		self:triggerIfNeeded(pos)
	end
	return fluidAmount
end

industrialtest.Compressor:register()

industrialtest.api.registerPumpTarget("industrialtest:compressor","o")
industrialtest.api.registerPumpTarget("industrialtest:compressor_active","o")

minetest.register_craft({
	type="shaped",
	output="industrialtest:compressor",
	recipe={
		{industrialtest.elementKeys.stone,"",industrialtest.elementKeys.stone},
		{industrialtest.elementKeys.stone,"industrialtest:machine_block",industrialtest.elementKeys.stone},
		{industrialtest.elementKeys.stone,"industrialtest:electronic_circuit",industrialtest.elementKeys.stone}
	}
})
