-- IndustrialTest
-- Copyright (C) 2024 mrkubax10

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local S=minetest.get_translator("industrialtest")
industrialtest.JetpackBase=table.copy(industrialtest.GearTool)
industrialtest.internal.unpackTableInto(industrialtest.JetpackBase,{
	part="torso"
})
local soundHandles = {}

function industrialtest.JetpackBase.update(self, player, inv, itemstack, dtime)
	local playerName = player:get_player_name()
	local control = player:get_player_control()
	if control.jump and self:tryFly(itemstack) then
		industrialtest.internal.addYVelocityClamped(player,1,10)
		if not soundHandles[playerName] then
			local pos = player:get_pos()
			local handle = minetest.sound_play("industrialtest_jetpack_loop", {
				pos = pos,
				gain = 1.0, -- Volume of the sound
				max_hear_distance = 16, -- Maximum distance to hear the sound
				object = player, -- Attach the sound to the player
				loop = true, -- The sound is played in a loop
			})
			soundHandles[playerName] = handle
		end
		return true
	else
		if soundHandles[playerName] then
			minetest.sound_stop(soundHandles[playerName])
			soundHandles[playerName] = nil
		end
	end
	return false
end

industrialtest.Jetpack=table.copy(industrialtest.JetpackBase)
industrialtest.internal.unpackTableInto(industrialtest.Jetpack,{
	-- _v is hack to suppress "Registered armor doesn't have material at the end of registration name" warning from 3D Armor.
	name="industrialtest:jetpack_v",
	description=S("Jetpack"),
	inventoryImage="industrialtest_jetpack_v_inv.png",
	modelImage="industrialtest_jetpack_v.png",
	capacity=5000,
	prepare=industrialtest.FluidContainerItem.prepare
})

function industrialtest.Jetpack.createDefinitionTable(self)
	local def=industrialtest.JetpackBase.createDefinitionTable(self)
	def.groups._industrialtest_fueled=1
	return def
end

function industrialtest.Jetpack.tryFly(self,itemstack)
	if industrialtest.api.isItemFluidStorageEmpty(itemstack) then
		return false
	end
	industrialtest.api.addFluidToItem(itemstack,-1)
	return true
end

industrialtest.Jetpack:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:jetpack_v",
	recipe={
		{"industrialtest:refined_iron_ingot","industrialtest:electronic_circuit","industrialtest:refined_iron_ingot"},
		{"industrialtest:refined_iron_ingot","industrialtest:fuel_can","industrialtest:refined_iron_ingot"},
		{industrialtest.elementKeys.powerCarrier,"",industrialtest.elementKeys.powerCarrier}
	}
})

industrialtest.ElectricJetpack=table.copy(industrialtest.JetpackBase)
industrialtest.internal.unpackTableInto(industrialtest.ElectricJetpack,{
	name="industrialtest:electric_jetpack",
	description=S("Electric Jetpack"),
	inventoryImage="industrialtest_electric_jetpack_inv.png",
	modelImage="industrialtest_electric_jetpack.png",
	flow=industrialtest.api.lvPowerFlow,
	capacity=30000,
	prepare=industrialtest.ElectricItem.prepare,
	_opPower=10
})

function industrialtest.ElectricJetpack.tryFly(self,itemstack)
	local meta=itemstack:get_meta()
	if meta:get_int("industrialtest.powerAmount")<self._opPower then
		return false
	end
	industrialtest.api.addPowerToItem(itemstack,-self._opPower)
	return true
end

industrialtest.ElectricJetpack:register()

minetest.register_craft({
	type="shaped",
	output="industrialtest:electric_jetpack",
	recipe={
		{"industrialtest:refined_iron_ingot","industrialtest:advanced_electronic_circuit","industrialtest:refined_iron_ingot"},
		{"industrialtest:refined_iron_ingot","industrialtest:batbox","industrialtest:refined_iron_ingot"},
		{industrialtest.elementKeys.yellowDust,"",industrialtest.elementKeys.yellowDust}
	}
})
